/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.Loxodrome;
import org.orekit.bodies.OneAxisEllipsoid;

public class LoxodromeArc
extends Loxodrome {
    private static final double LATITUDE_THRESHOLD = 1.0E-6;
    private static final int MAX_ITER = 50;
    private final GeodeticPoint endPoint;
    private final double deltaLon;
    private double distance = -1.0;

    public LoxodromeArc(GeodeticPoint point, GeodeticPoint endPoint, OneAxisEllipsoid body) {
        this(point, endPoint, body, (point.getAltitude() + endPoint.getAltitude()) / 2.0);
    }

    public LoxodromeArc(GeodeticPoint point, GeodeticPoint endPoint, OneAxisEllipsoid body, double altitude) {
        super(point, body.azimuthBetweenPoints(point, endPoint), body, altitude);
        this.endPoint = endPoint;
        this.deltaLon = MathUtils.normalizeAngle((double)endPoint.getLongitude(), (double)point.getLongitude()) - point.getLongitude();
    }

    public GeodeticPoint getFinalPoint() {
        return this.endPoint;
    }

    public double getDistance() {
        if (this.distance >= 0.0) {
            return this.distance;
        }
        double ptLat = this.getPoint().getLatitude();
        double sinLat = FastMath.sin((double)ptLat);
        double eccSinLatSq = this.getBody().getEccentricitySquared() * sinLat * sinLat;
        double t1 = 1.0 - this.getBody().getEccentricitySquared();
        double t2 = 1.0 - eccSinLatSq;
        double t3 = FastMath.sqrt((double)t2);
        double semiMajorAxis = this.getBody().getEquatorialRadius() + this.getAltitude();
        double meridianCurve = semiMajorAxis * t1 / (t2 * t3);
        if (FastMath.abs((double)(this.endPoint.getLatitude() - ptLat)) < 1.0E-6) {
            this.distance = semiMajorAxis / t3 * FastMath.abs((double)(FastMath.cos((double)ptLat) * this.deltaLon));
        } else {
            double eccSq34 = 0.75 * this.getBody().getEccentricitySquared();
            double halfEccSq34 = eccSq34 / 2.0;
            double t6 = 1.0 / (1.0 - eccSq34);
            double t7 = t1 * semiMajorAxis / meridianCurve;
            double t8 = ptLat + t6 * (t7 * (this.endPoint.getLatitude() - ptLat) + halfEccSq34 * FastMath.sin((double)(ptLat * 2.0)));
            double t9 = halfEccSq34 * t6;
            double guess = 0.0;
            double lat = this.endPoint.getLatitude();
            for (int i = 0; i < 50 && !(FastMath.abs((double)((lat = t8 - t9 * FastMath.sin((double)(2.0 * (guess = lat)))) - guess)) < 1.0E-6); ++i) {
            }
            double azimuth = FastMath.atan2((double)this.deltaLon, (double)(this.getBody().geodeticToIsometricLatitude(lat) - this.getBody().geodeticToIsometricLatitude(ptLat)));
            this.distance = meridianCurve * FastMath.abs((double)((lat - ptLat) / FastMath.cos((double)azimuth)));
        }
        return this.distance;
    }

    public GeodeticPoint calculatePointAlongArc(double fraction) {
        if (fraction == 0.0) {
            return this.getPoint();
        }
        if (fraction == 1.0) {
            return this.getFinalPoint();
        }
        double d = this.getDistance() * fraction;
        return this.pointAtDistance(d);
    }
}

