/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import org.hipparchus.util.FastMath;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;

public class Loxodrome {
    private static final double COS_ANGLE_THRESHOLD = 1.0E-6;
    private static final double DISTANCE_THRESHOLD = 1.0E-9;
    private final GeodeticPoint point;
    private final double azimuth;
    private final OneAxisEllipsoid body;
    private final double altitude;

    public Loxodrome(GeodeticPoint point, double azimuth, OneAxisEllipsoid body) {
        this(point, azimuth, body, point.getAltitude());
    }

    public Loxodrome(GeodeticPoint point, double azimuth, OneAxisEllipsoid body, double altitude) {
        this.point = point;
        this.azimuth = azimuth;
        this.body = body;
        this.altitude = altitude;
    }

    public GeodeticPoint getPoint() {
        return this.point;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public OneAxisEllipsoid getBody() {
        return this.body;
    }

    public double getAltitude() {
        return this.altitude;
    }

    public GeodeticPoint pointAtDistance(double distance) {
        double lon;
        double lat;
        if (FastMath.abs((double)distance) < 1.0E-9) {
            return this.point;
        }
        double sinLat = FastMath.sin((double)this.point.getLatitude());
        double eccSinLatSq = this.body.getEccentricitySquared() * sinLat * sinLat;
        double t1 = 1.0 - this.body.getEccentricitySquared();
        double t2 = 1.0 - eccSinLatSq;
        double t3 = FastMath.sqrt((double)t2);
        double semiMajorAxis = this.getBody().getEquatorialRadius() + this.getAltitude();
        double meridianCurve = semiMajorAxis * t1 / (t2 * t3);
        double cosAzimuth = FastMath.cos((double)this.azimuth);
        if (FastMath.abs((double)cosAzimuth) < 1.0E-6) {
            lat = this.point.getLatitude();
            lon = this.point.getLongitude() + distance * FastMath.sin((double)this.azimuth) * t3 / semiMajorAxis * FastMath.cos((double)this.point.getLatitude());
        } else {
            double eccSq34 = 0.75 * this.body.getEccentricitySquared();
            double halfEccSq34 = eccSq34 / 2.0;
            double t4 = meridianCurve / (t1 * semiMajorAxis);
            double latPrime = this.point.getLatitude() + distance * cosAzimuth / meridianCurve;
            double latOffset = t4 * ((1.0 - eccSq34) * (latPrime - this.point.getLatitude()) + halfEccSq34 * (FastMath.sin((double)(2.0 * latPrime)) - FastMath.sin((double)(2.0 * this.point.getLatitude()))));
            lat = Loxodrome.fixLatitude(this.point.getLatitude() + latOffset);
            double lonOffset = FastMath.tan((double)this.azimuth) * (this.body.geodeticToIsometricLatitude(lat) - this.body.geodeticToIsometricLatitude(this.point.getLatitude()));
            lon = this.point.getLongitude() + lonOffset;
        }
        return new GeodeticPoint(lat, lon, this.getAltitude());
    }

    static double fixLatitude(double lat) {
        if (lat < -1.5707963267948966) {
            return -1.5707963267948966;
        }
        if (lat > 1.5707963267948966) {
            return 1.5707963267948966;
        }
        return lat;
    }
}

