/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.orekit.bodies.CelestialBodies;
import org.orekit.bodies.CelestialBody;
import org.orekit.bodies.CelestialBodyLoader;
import org.orekit.bodies.JPLEphemeridesLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.time.TimeScales;

public class LazyLoadedCelestialBodies
implements CelestialBodies {
    private final DataProvidersManager dataProvidersManager;
    private final TimeScales timeScales;
    private final Frame gcrf;
    private final Map<String, List<CelestialBodyLoader>> loadersMap = new HashMap<String, List<CelestialBodyLoader>>();
    private final Map<String, CelestialBody> celestialBodyMap = new HashMap<String, CelestialBody>();

    public LazyLoadedCelestialBodies(DataProvidersManager dataProvidersManager, TimeScales timeScales, Frame gcrf) {
        this.dataProvidersManager = dataProvidersManager;
        this.timeScales = timeScales;
        this.gcrf = gcrf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCelestialBodyLoader(String name, CelestialBodyLoader loader) {
        Map<String, List<CelestialBodyLoader>> map = this.loadersMap;
        synchronized (map) {
            this.loadersMap.computeIfAbsent(name, k -> new ArrayList()).add(loader);
        }
    }

    public void addDefaultCelestialBodyLoader(String supportedNames) {
        this.addDefaultCelestialBodyLoader("solar system barycenter", supportedNames);
        this.addDefaultCelestialBodyLoader("Sun", supportedNames);
        this.addDefaultCelestialBodyLoader("Mercury", supportedNames);
        this.addDefaultCelestialBodyLoader("Venus", supportedNames);
        this.addDefaultCelestialBodyLoader("Earth-Moon barycenter", supportedNames);
        this.addDefaultCelestialBodyLoader("Earth", supportedNames);
        this.addDefaultCelestialBodyLoader("Moon", supportedNames);
        this.addDefaultCelestialBodyLoader("Mars", supportedNames);
        this.addDefaultCelestialBodyLoader("Jupiter", supportedNames);
        this.addDefaultCelestialBodyLoader("Saturn", supportedNames);
        this.addDefaultCelestialBodyLoader("Uranus", supportedNames);
        this.addDefaultCelestialBodyLoader("Neptune", supportedNames);
        this.addDefaultCelestialBodyLoader("Pluto", supportedNames);
    }

    public void addDefaultCelestialBodyLoader(String name, String supportedNames) {
        JPLEphemeridesLoader loader = null;
        if (name.equalsIgnoreCase("solar system barycenter")) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.SOLAR_SYSTEM_BARYCENTER, this.dataProvidersManager, this.timeScales, this.gcrf);
        } else if (name.equalsIgnoreCase("Sun")) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.SUN, this.dataProvidersManager, this.timeScales, this.gcrf);
        } else if (name.equalsIgnoreCase("Mercury")) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.MERCURY, this.dataProvidersManager, this.timeScales, this.gcrf);
        } else if (name.equalsIgnoreCase("Venus")) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.VENUS, this.dataProvidersManager, this.timeScales, this.gcrf);
        } else if (name.equalsIgnoreCase("Earth-Moon barycenter")) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.EARTH_MOON, this.dataProvidersManager, this.timeScales, this.gcrf);
        } else if (name.equalsIgnoreCase("Earth")) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.EARTH, this.dataProvidersManager, this.timeScales, this.gcrf);
        } else if (name.equalsIgnoreCase("Moon")) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.MOON, this.dataProvidersManager, this.timeScales, this.gcrf);
        } else if (name.equalsIgnoreCase("Mars")) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.MARS, this.dataProvidersManager, this.timeScales, this.gcrf);
        } else if (name.equalsIgnoreCase("Jupiter")) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.JUPITER, this.dataProvidersManager, this.timeScales, this.gcrf);
        } else if (name.equalsIgnoreCase("Saturn")) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.SATURN, this.dataProvidersManager, this.timeScales, this.gcrf);
        } else if (name.equalsIgnoreCase("Uranus")) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.URANUS, this.dataProvidersManager, this.timeScales, this.gcrf);
        } else if (name.equalsIgnoreCase("Neptune")) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.NEPTUNE, this.dataProvidersManager, this.timeScales, this.gcrf);
        } else if (name.equalsIgnoreCase("Pluto")) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.PLUTO, this.dataProvidersManager, this.timeScales, this.gcrf);
        }
        if (loader != null) {
            this.addCelestialBodyLoader(name, loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCelestialBodyLoaders(String name) {
        Map<String, CelestialBody> map = this.celestialBodyMap;
        synchronized (map) {
            this.clearCelestialBodyCache(name);
            Map<String, List<CelestialBodyLoader>> map2 = this.loadersMap;
            synchronized (map2) {
                this.loadersMap.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCelestialBodyLoaders() {
        Map<String, CelestialBody> map = this.celestialBodyMap;
        synchronized (map) {
            this.clearCelestialBodyCache();
            Map<String, List<CelestialBodyLoader>> map2 = this.loadersMap;
            synchronized (map2) {
                this.loadersMap.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCelestialBodyCache(String name) {
        Map<String, CelestialBody> map = this.celestialBodyMap;
        synchronized (map) {
            this.celestialBodyMap.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCelestialBodyCache() {
        Map<String, CelestialBody> map = this.celestialBodyMap;
        synchronized (map) {
            this.celestialBodyMap.clear();
        }
    }

    @Override
    public CelestialBody getSolarSystemBarycenter() {
        return this.getBody("solar system barycenter");
    }

    @Override
    public CelestialBody getSun() {
        return this.getBody("Sun");
    }

    @Override
    public CelestialBody getMercury() {
        return this.getBody("Mercury");
    }

    @Override
    public CelestialBody getVenus() {
        return this.getBody("Venus");
    }

    @Override
    public CelestialBody getEarthMoonBarycenter() {
        return this.getBody("Earth-Moon barycenter");
    }

    @Override
    public CelestialBody getEarth() {
        return this.getBody("Earth");
    }

    @Override
    public CelestialBody getMoon() {
        return this.getBody("Moon");
    }

    @Override
    public CelestialBody getMars() {
        return this.getBody("Mars");
    }

    @Override
    public CelestialBody getJupiter() {
        return this.getBody("Jupiter");
    }

    @Override
    public CelestialBody getSaturn() {
        return this.getBody("Saturn");
    }

    @Override
    public CelestialBody getUranus() {
        return this.getBody("Uranus");
    }

    @Override
    public CelestialBody getNeptune() {
        return this.getBody("Neptune");
    }

    @Override
    public CelestialBody getPluto() {
        return this.getBody("Pluto");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CelestialBody getBody(String name) {
        Map<String, CelestialBody> map = this.celestialBodyMap;
        synchronized (map) {
            CelestialBody body = this.celestialBodyMap.get(name);
            if (body == null) {
                Map<String, List<CelestialBodyLoader>> map2 = this.loadersMap;
                synchronized (map2) {
                    List<CelestialBodyLoader> loaders = this.loadersMap.get(name);
                    if (loaders == null || loaders.isEmpty()) {
                        this.addDefaultCelestialBodyLoader(name, "^[lu]nx([mp](\\d\\d\\d\\d))+\\.(?:4\\d\\d)$");
                        this.addDefaultCelestialBodyLoader(name, "^inpop.*\\.dat$");
                        loaders = this.loadersMap.get(name);
                    }
                    OrekitException delayedException = null;
                    for (CelestialBodyLoader loader : loaders) {
                        try {
                            body = loader.loadCelestialBody(name);
                            if (body == null) continue;
                            break;
                        }
                        catch (OrekitException oe) {
                            delayedException = oe;
                        }
                    }
                    if (body == null) {
                        throw delayedException != null ? delayedException : new OrekitException((Localizable)OrekitMessages.NO_DATA_LOADED_FOR_CELESTIAL_BODY, name);
                    }
                }
                this.celestialBodyMap.put(name, body);
            }
            return body;
        }
    }
}

