/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.twod.FieldVector2D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.orekit.frames.Frame;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldEllipse<T extends CalculusFieldElement<T>> {
    private static final double ANGULAR_THRESHOLD = 1.0E-12;
    private final FieldVector3D<T> center;
    private final FieldVector3D<T> u;
    private final FieldVector3D<T> v;
    private final T a;
    private final T b;
    private final Frame frame;
    private final T a2;
    private final T b2;
    private final T e2;
    private final T g;
    private final T g2;
    private final T evoluteFactorX;
    private final T evoluteFactorY;

    public FieldEllipse(FieldVector3D<T> center, FieldVector3D<T> u, FieldVector3D<T> v, T a, T b, Frame frame) {
        this.center = center;
        this.u = u;
        this.v = v;
        this.a = a;
        this.b = b;
        this.frame = frame;
        this.a2 = (CalculusFieldElement)a.square();
        this.g = (CalculusFieldElement)b.divide(a);
        this.g2 = (CalculusFieldElement)this.g.multiply(this.g);
        this.e2 = (CalculusFieldElement)((CalculusFieldElement)this.g2.negate()).add(1.0);
        this.b2 = (CalculusFieldElement)b.square();
        this.evoluteFactorX = (CalculusFieldElement)((CalculusFieldElement)this.a2.subtract(this.b2)).divide((FieldElement)((CalculusFieldElement)this.a2.square()));
        this.evoluteFactorY = (CalculusFieldElement)((CalculusFieldElement)this.b2.subtract(this.a2)).divide((FieldElement)((CalculusFieldElement)this.b2.square()));
    }

    public FieldVector3D<T> getCenter() {
        return this.center;
    }

    public FieldVector3D<T> getU() {
        return this.u;
    }

    public FieldVector3D<T> getV() {
        return this.v;
    }

    public T getA() {
        return this.a;
    }

    public T getB() {
        return this.b;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public FieldVector3D<T> pointAt(T theta) {
        FieldSinCos scTheta = FastMath.sinCos(theta);
        return this.toSpace(new FieldVector2D((CalculusFieldElement)this.a.multiply((FieldElement)((CalculusFieldElement)scTheta.cos())), (CalculusFieldElement)this.b.multiply((FieldElement)((CalculusFieldElement)scTheta.sin()))));
    }

    public FieldVector3D<T> toSpace(FieldVector2D<T> p) {
        return new FieldVector3D((CalculusFieldElement)this.a.getField().getOne(), this.center, p.getX(), this.u, p.getY(), this.v);
    }

    public FieldVector2D<T> toPlane(FieldVector3D<T> p) {
        FieldVector3D delta = p.subtract(this.center);
        return new FieldVector2D(FieldVector3D.dotProduct((FieldVector3D)delta, this.u), FieldVector3D.dotProduct((FieldVector3D)delta, this.v));
    }

    public FieldVector2D<T> projectToEllipse(FieldVector2D<T> p) {
        CalculusFieldElement x = FastMath.abs((CalculusFieldElement)p.getX());
        CalculusFieldElement y = p.getY();
        if (x.getReal() <= 1.0E-12 * FastMath.abs((double)y.getReal())) {
            CalculusFieldElement osculatingRadius = (CalculusFieldElement)this.a2.divide(this.b);
            CalculusFieldElement evoluteCuspZ = FastMath.copySign((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.a.multiply(this.e2)).divide(this.g)), (CalculusFieldElement)((CalculusFieldElement)y.negate()));
            CalculusFieldElement deltaZ = (CalculusFieldElement)y.subtract((FieldElement)evoluteCuspZ);
            CalculusFieldElement ratio = (CalculusFieldElement)osculatingRadius.divide((FieldElement)FastMath.hypot((CalculusFieldElement)deltaZ, (CalculusFieldElement)x));
            return new FieldVector2D(FastMath.copySign((CalculusFieldElement)((CalculusFieldElement)ratio.multiply((FieldElement)x)), (CalculusFieldElement)p.getX()), (CalculusFieldElement)evoluteCuspZ.add((FieldElement)((CalculusFieldElement)ratio.multiply((FieldElement)deltaZ))));
        }
        if (FastMath.abs((double)y.getReal()) <= 1.0E-12 * x.getReal()) {
            CalculusFieldElement osculatingRadius = (CalculusFieldElement)this.b2.divide(this.a);
            CalculusFieldElement evoluteCuspR = (CalculusFieldElement)this.a.multiply(this.e2);
            CalculusFieldElement deltaR = (CalculusFieldElement)x.subtract((FieldElement)evoluteCuspR);
            if (deltaR.getReal() >= 0.0) {
                CalculusFieldElement ratio = (CalculusFieldElement)osculatingRadius.divide((FieldElement)FastMath.hypot((CalculusFieldElement)y, (CalculusFieldElement)deltaR));
                return new FieldVector2D(FastMath.copySign((CalculusFieldElement)((CalculusFieldElement)evoluteCuspR.add((FieldElement)((CalculusFieldElement)ratio.multiply((FieldElement)deltaR)))), (CalculusFieldElement)p.getX()), (CalculusFieldElement)ratio.multiply((FieldElement)y));
            }
            CalculusFieldElement rEllipse = (CalculusFieldElement)x.divide(this.e2);
            return new FieldVector2D(FastMath.copySign((CalculusFieldElement)rEllipse, (CalculusFieldElement)p.getX()), FastMath.copySign((CalculusFieldElement)((CalculusFieldElement)this.g.multiply((FieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)this.a2.subtract((FieldElement)((CalculusFieldElement)rEllipse.multiply((FieldElement)rEllipse))))))), (CalculusFieldElement)y));
        }
        CalculusFieldElement omegaX = (CalculusFieldElement)this.a.multiply(this.e2);
        CalculusFieldElement omegaY = (CalculusFieldElement)this.a.getField().getZero();
        CalculusFieldElement projectedX = x;
        CalculusFieldElement projectedY = y;
        double deltaX = Double.POSITIVE_INFINITY;
        double deltaY = Double.POSITIVE_INFINITY;
        int count = 0;
        double threshold = 1.0E-24 * this.a2.getReal();
        while (deltaX * deltaX + deltaY * deltaY > threshold && count++ < 100) {
            CalculusFieldElement dx = (CalculusFieldElement)x.subtract((FieldElement)omegaX);
            CalculusFieldElement dy = (CalculusFieldElement)y.subtract((FieldElement)omegaY);
            CalculusFieldElement alpha = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.b2.multiply((FieldElement)dx)).multiply((FieldElement)dx)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.a2.multiply((FieldElement)dy)).multiply((FieldElement)dy)));
            CalculusFieldElement betaPrime = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.b2.multiply((FieldElement)omegaX)).multiply((FieldElement)dx)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.a2.multiply((FieldElement)omegaY)).multiply((FieldElement)dy)));
            CalculusFieldElement gamma = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.b2.multiply((FieldElement)omegaX)).multiply((FieldElement)omegaX)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.a2.multiply((FieldElement)omegaY)).multiply((FieldElement)omegaY)))).subtract((FieldElement)((CalculusFieldElement)this.a2.multiply(this.b2)));
            CalculusFieldElement deltaPrime = (CalculusFieldElement)this.a.linearCombination((FieldElement)betaPrime, (FieldElement)betaPrime, (FieldElement)((CalculusFieldElement)alpha.negate()), (FieldElement)gamma);
            CalculusFieldElement ratio = betaPrime.getReal() <= 0.0 ? (CalculusFieldElement)((CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)deltaPrime).subtract((FieldElement)betaPrime)).divide((FieldElement)alpha) : (CalculusFieldElement)((CalculusFieldElement)gamma.negate()).divide((FieldElement)((CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)deltaPrime).add((FieldElement)betaPrime)));
            CalculusFieldElement previousX = projectedX;
            CalculusFieldElement previousY = projectedY;
            projectedX = (CalculusFieldElement)omegaX.add((FieldElement)((CalculusFieldElement)ratio.multiply((FieldElement)dx)));
            projectedY = (CalculusFieldElement)omegaY.add((FieldElement)((CalculusFieldElement)ratio.multiply((FieldElement)dy)));
            omegaX = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.evoluteFactorX.multiply((FieldElement)projectedX)).multiply((FieldElement)projectedX)).multiply((FieldElement)projectedX);
            omegaY = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.evoluteFactorY.multiply((FieldElement)projectedY)).multiply((FieldElement)projectedY)).multiply((FieldElement)projectedY);
            deltaX = ((CalculusFieldElement)projectedX.subtract((FieldElement)previousX)).getReal();
            deltaY = ((CalculusFieldElement)projectedY.subtract((FieldElement)previousY)).getReal();
        }
        return new FieldVector2D(FastMath.copySign((CalculusFieldElement)projectedX, (CalculusFieldElement)p.getX()), projectedY);
    }

    public TimeStampedFieldPVCoordinates<T> projectToEllipse(TimeStampedFieldPVCoordinates<T> pv) {
        FieldVector2D p2D = this.toPlane(pv.getPosition());
        FieldVector2D e2D = this.projectToEllipse(p2D);
        CalculusFieldElement fx = (CalculusFieldElement)((CalculusFieldElement)this.a2.negate()).multiply((FieldElement)e2D.getY());
        CalculusFieldElement fy = (CalculusFieldElement)this.b2.multiply((FieldElement)e2D.getX());
        CalculusFieldElement f2 = (CalculusFieldElement)((CalculusFieldElement)fx.square()).add((FieldElement)((CalculusFieldElement)fy.square()));
        CalculusFieldElement f = FastMath.sqrt((CalculusFieldElement)f2);
        FieldVector2D tangent = new FieldVector2D((CalculusFieldElement)fx.divide((FieldElement)f), (CalculusFieldElement)fy.divide((FieldElement)f));
        FieldVector2D normal = new FieldVector2D((CalculusFieldElement)tangent.getY().negate(), tangent.getX());
        CalculusFieldElement x2 = (CalculusFieldElement)e2D.getX().multiply((FieldElement)e2D.getX());
        CalculusFieldElement y2 = (CalculusFieldElement)e2D.getY().multiply((FieldElement)e2D.getY());
        CalculusFieldElement eX = (CalculusFieldElement)this.evoluteFactorX.multiply((FieldElement)x2);
        CalculusFieldElement eY = (CalculusFieldElement)this.evoluteFactorY.multiply((FieldElement)y2);
        CalculusFieldElement omegaX = (CalculusFieldElement)eX.multiply((FieldElement)e2D.getX());
        CalculusFieldElement omegaY = (CalculusFieldElement)eY.multiply((FieldElement)e2D.getY());
        CalculusFieldElement rho = FastMath.hypot((CalculusFieldElement)((CalculusFieldElement)e2D.getX().subtract((FieldElement)omegaX)), (CalculusFieldElement)((CalculusFieldElement)e2D.getY().subtract((FieldElement)omegaY)));
        CalculusFieldElement d = FastMath.hypot((CalculusFieldElement)((CalculusFieldElement)p2D.getX().subtract((FieldElement)omegaX)), (CalculusFieldElement)((CalculusFieldElement)p2D.getY().subtract((FieldElement)omegaY)));
        CalculusFieldElement projectionRatio = (CalculusFieldElement)rho.divide((FieldElement)d);
        FieldVector2D pDot2D = new FieldVector2D(FieldVector3D.dotProduct(pv.getVelocity(), this.u), FieldVector3D.dotProduct(pv.getVelocity(), this.v));
        CalculusFieldElement pDotTangent = pDot2D.dotProduct(tangent);
        CalculusFieldElement pDotNormal = pDot2D.dotProduct(normal);
        CalculusFieldElement eDotTangent = (CalculusFieldElement)projectionRatio.multiply((FieldElement)pDotTangent);
        FieldVector2D eDot2D = new FieldVector2D(eDotTangent, tangent);
        FieldVector2D tangentDot = new FieldVector2D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.a2.multiply(this.b2)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)e2D.getX().multiply((FieldElement)eDot2D.getY())).subtract((FieldElement)((CalculusFieldElement)e2D.getY().multiply((FieldElement)eDot2D.getX())))))).divide((FieldElement)f2), normal);
        CalculusFieldElement omegaXDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)eX.multiply((FieldElement)eDotTangent)).multiply((FieldElement)tangent.getX())).multiply(3);
        CalculusFieldElement omegaYDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)eY.multiply((FieldElement)eDotTangent)).multiply((FieldElement)tangent.getY())).multiply(3);
        CalculusFieldElement voz = (CalculusFieldElement)((CalculusFieldElement)omegaXDot.multiply((FieldElement)tangent.getY())).subtract((FieldElement)((CalculusFieldElement)omegaYDot.multiply((FieldElement)tangent.getX())));
        CalculusFieldElement vsz = (CalculusFieldElement)pDotNormal.negate();
        CalculusFieldElement projectionRatioDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)rho.subtract((FieldElement)d)).multiply((FieldElement)voz)).subtract((FieldElement)((CalculusFieldElement)rho.multiply((FieldElement)vsz)))).divide((FieldElement)((CalculusFieldElement)d.multiply((FieldElement)d)));
        FieldVector2D pDotDot2D = new FieldVector2D(FieldVector3D.dotProduct(pv.getAcceleration(), this.u), FieldVector3D.dotProduct(pv.getAcceleration(), this.v));
        CalculusFieldElement pDotDotTangent = pDotDot2D.dotProduct(tangent);
        CalculusFieldElement pDotTangentDot = pDot2D.dotProduct(tangentDot);
        CalculusFieldElement eDotDotTangent = (CalculusFieldElement)((CalculusFieldElement)projectionRatio.multiply((FieldElement)((CalculusFieldElement)pDotDotTangent.add((FieldElement)pDotTangentDot)))).add((FieldElement)((CalculusFieldElement)projectionRatioDot.multiply((FieldElement)pDotTangent)));
        FieldVector2D eDotDot2D = new FieldVector2D(eDotDotTangent, tangent, eDotTangent, tangentDot);
        FieldVector3D e3D = this.toSpace(e2D);
        FieldVector3D eDot3D = new FieldVector3D(eDot2D.getX(), this.u, eDot2D.getY(), this.v);
        FieldVector3D eDotDot3D = new FieldVector3D(eDotDot2D.getX(), this.u, eDotDot2D.getY(), this.v);
        return new TimeStampedFieldPVCoordinates<T>(pv.getDate(), e3D, eDot3D, eDotDot3D);
    }

    public FieldVector2D<T> getCenterOfCurvature(FieldVector2D<T> point) {
        FieldVector2D<T> projected = this.projectToEllipse(point);
        return new FieldVector2D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.evoluteFactorX.multiply((FieldElement)projected.getX())).multiply((FieldElement)projected.getX())).multiply((FieldElement)projected.getX()), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.evoluteFactorY.multiply((FieldElement)projected.getY())).multiply((FieldElement)projected.getY())).multiply((FieldElement)projected.getY()));
    }
}

