/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import java.io.Serializable;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.euclidean.twod.FieldVector2D;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.Precision;
import org.orekit.bodies.Ellipse;
import org.orekit.bodies.FieldEllipse;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;

public class Ellipsoid
implements Serializable {
    private static final long serialVersionUID = 20140924L;
    private final Frame frame;
    private final double a;
    private final double b;
    private final double c;

    public Ellipsoid(Frame frame, double a, double b, double c) {
        this.frame = frame;
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getC() {
        return this.c;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public boolean isInside(Vector3D point) {
        double scaledZ;
        double scaledY;
        double scaledX = point.getX() / this.a;
        return scaledX * scaledX + (scaledY = point.getY() / this.b) * scaledY + (scaledZ = point.getZ() / this.c) * scaledZ <= 1.0;
    }

    public <T extends CalculusFieldElement<T>> boolean isInside(FieldVector3D<T> point) {
        CalculusFieldElement scaledX = (CalculusFieldElement)point.getX().divide(this.a);
        CalculusFieldElement scaledY = (CalculusFieldElement)point.getY().divide(this.b);
        CalculusFieldElement scaledZ = (CalculusFieldElement)point.getZ().divide(this.c);
        CalculusFieldElement d2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)scaledX.multiply((FieldElement)scaledX)).add((FieldElement)((CalculusFieldElement)scaledY.multiply((FieldElement)scaledY)))).add((FieldElement)((CalculusFieldElement)scaledZ.multiply((FieldElement)scaledZ)));
        return ((CalculusFieldElement)d2.subtract(1.0)).getReal() <= 0.0;
    }

    public Ellipse getPlaneSection(Vector3D planePoint, Vector3D planeNormal) throws MathRuntimeException {
        double m;
        double bMA;
        Vector3D u = planeNormal.orthogonal();
        Vector3D v = (Vector3D)Vector3D.crossProduct((Vector3D)planeNormal, (Vector3D)u).normalize();
        double xUOa = u.getX() / this.a;
        double yUOb = u.getY() / this.b;
        double zUOc = u.getZ() / this.c;
        double xVOa = v.getX() / this.a;
        double yVOb = v.getY() / this.b;
        double zVOc = v.getZ() / this.c;
        double xPOa = planePoint.getX() / this.a;
        double yPOb = planePoint.getY() / this.b;
        double zPOc = planePoint.getZ() / this.c;
        double alpha = xUOa * xUOa + yUOb * yUOb + zUOc * zUOc;
        double beta = xVOa * xVOa + yVOb * yVOb + zVOc * zVOc;
        double gamma = MathArrays.linearCombination((double)xUOa, (double)xVOa, (double)yUOb, (double)yVOb, (double)zUOc, (double)zVOc);
        double delta = MathArrays.linearCombination((double)xPOa, (double)xUOa, (double)yPOb, (double)yUOb, (double)zPOc, (double)zUOc);
        double epsilon = MathArrays.linearCombination((double)xPOa, (double)xVOa, (double)yPOb, (double)yVOb, (double)zPOc, (double)zVOc);
        double zeta = MathArrays.linearCombination((double)xPOa, (double)xPOa, (double)yPOb, (double)yPOb, (double)zPOc, (double)zPOc, (double)1.0, (double)-1.0);
        double tanTheta = FastMath.abs((double)gamma) < Precision.SAFE_MIN ? 0.0 : ((bMA = beta - alpha) >= 0.0 ? -2.0 * gamma / (bMA + FastMath.sqrt((double)(bMA * bMA + 4.0 * gamma * gamma))) : -2.0 * gamma / (bMA - FastMath.sqrt((double)(bMA * bMA + 4.0 * gamma * gamma))));
        double tan2 = tanTheta * tanTheta;
        double cos2 = 1.0 / (1.0 + tan2);
        double sin2 = tan2 * cos2;
        double cosSin = tanTheta * cos2;
        double cos = FastMath.sqrt((double)cos2);
        double sin = tanTheta * cos;
        double denom = MathArrays.linearCombination((double)gamma, (double)gamma, (double)(-alpha), (double)beta);
        double tauC = MathArrays.linearCombination((double)beta, (double)delta, (double)(-gamma), (double)epsilon) / denom;
        double nuC = MathArrays.linearCombination((double)alpha, (double)epsilon, (double)(-gamma), (double)delta) / denom;
        double twogcs = 2.0 * gamma * cosSin;
        double bigA = alpha * cos2 + beta * sin2 + twogcs;
        double bigB = alpha * sin2 + beta * cos2 - twogcs;
        double bigF = (alpha * tauC + 2.0 * (gamma * nuC + delta)) * tauC + (beta * nuC + 2.0 * epsilon) * nuC + zeta;
        double l = FastMath.sqrt((double)(-bigF / bigA));
        if (Double.isNaN(l + (m = FastMath.sqrt((double)(-bigF / bigB))))) {
            return null;
        }
        if (l > m) {
            return new Ellipse(new Vector3D(1.0, planePoint, tauC, u, nuC, v), new Vector3D(cos, u, sin, v), new Vector3D(-sin, u, cos, v), l, m, this.frame);
        }
        return new Ellipse(new Vector3D(1.0, planePoint, tauC, u, nuC, v), new Vector3D(sin, u, -cos, v), new Vector3D(cos, u, sin, v), m, l, this.frame);
    }

    public <T extends CalculusFieldElement<T>> FieldEllipse<T> getPlaneSection(FieldVector3D<T> planePoint, FieldVector3D<T> planeNormal) throws MathRuntimeException {
        CalculusFieldElement m;
        CalculusFieldElement bMA;
        CalculusFieldElement zero = (CalculusFieldElement)planePoint.getX().getField().getZero();
        CalculusFieldElement one = (CalculusFieldElement)planePoint.getX().getField().getOne();
        FieldVector3D u = planeNormal.orthogonal();
        FieldVector3D v = FieldVector3D.crossProduct(planeNormal, (FieldVector3D)u).normalize();
        CalculusFieldElement xUOa = (CalculusFieldElement)u.getX().divide(this.a);
        CalculusFieldElement yUOb = (CalculusFieldElement)u.getY().divide(this.b);
        CalculusFieldElement zUOc = (CalculusFieldElement)u.getZ().divide(this.c);
        CalculusFieldElement xVOa = (CalculusFieldElement)v.getX().divide(this.a);
        CalculusFieldElement yVOb = (CalculusFieldElement)v.getY().divide(this.b);
        CalculusFieldElement zVOc = (CalculusFieldElement)v.getZ().divide(this.c);
        CalculusFieldElement xPOa = (CalculusFieldElement)planePoint.getX().divide(this.a);
        CalculusFieldElement yPOb = (CalculusFieldElement)planePoint.getY().divide(this.b);
        CalculusFieldElement zPOc = (CalculusFieldElement)planePoint.getZ().divide(this.c);
        CalculusFieldElement alpha = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)xUOa.multiply((FieldElement)xUOa)).add((FieldElement)((CalculusFieldElement)yUOb.multiply((FieldElement)yUOb)))).add((FieldElement)((CalculusFieldElement)zUOc.multiply((FieldElement)zUOc)));
        CalculusFieldElement beta = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)xVOa.multiply((FieldElement)xVOa)).add((FieldElement)((CalculusFieldElement)yVOb.multiply((FieldElement)yVOb)))).add((FieldElement)((CalculusFieldElement)zVOc.multiply((FieldElement)zVOc)));
        CalculusFieldElement gamma = (CalculusFieldElement)alpha.linearCombination((FieldElement)xUOa, (FieldElement)xVOa, (FieldElement)yUOb, (FieldElement)yVOb, (FieldElement)zUOc, (FieldElement)zVOc);
        CalculusFieldElement delta = (CalculusFieldElement)alpha.linearCombination((FieldElement)xPOa, (FieldElement)xUOa, (FieldElement)yPOb, (FieldElement)yUOb, (FieldElement)zPOc, (FieldElement)zUOc);
        CalculusFieldElement epsilon = (CalculusFieldElement)alpha.linearCombination((FieldElement)xPOa, (FieldElement)xVOa, (FieldElement)yPOb, (FieldElement)yVOb, (FieldElement)zPOc, (FieldElement)zVOc);
        CalculusFieldElement zeta = (CalculusFieldElement)alpha.linearCombination((FieldElement)xPOa, (FieldElement)xPOa, (FieldElement)yPOb, (FieldElement)yPOb, (FieldElement)zPOc, (FieldElement)zPOc, (FieldElement)one, (FieldElement)((CalculusFieldElement)one.negate()));
        CalculusFieldElement tanTheta = FastMath.abs((double)gamma.getReal()) < Precision.SAFE_MIN ? zero : ((bMA = (CalculusFieldElement)beta.subtract((FieldElement)alpha)).getReal() >= 0.0 ? (CalculusFieldElement)((CalculusFieldElement)gamma.multiply(-2)).divide((FieldElement)((CalculusFieldElement)bMA.add((FieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)bMA.multiply((FieldElement)bMA)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)gamma.multiply((FieldElement)gamma)).multiply(4)))))))) : (CalculusFieldElement)((CalculusFieldElement)gamma.multiply(-2)).divide((FieldElement)((CalculusFieldElement)bMA.subtract((FieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)bMA.multiply((FieldElement)bMA)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)gamma.multiply((FieldElement)gamma)).multiply(4)))))))));
        CalculusFieldElement tan2 = (CalculusFieldElement)tanTheta.multiply((FieldElement)tanTheta);
        CalculusFieldElement cos2 = (CalculusFieldElement)((CalculusFieldElement)tan2.add(1.0)).reciprocal();
        CalculusFieldElement sin2 = (CalculusFieldElement)tan2.multiply((FieldElement)cos2);
        CalculusFieldElement cosSin = (CalculusFieldElement)tanTheta.multiply((FieldElement)cos2);
        CalculusFieldElement cos = FastMath.sqrt((CalculusFieldElement)cos2);
        CalculusFieldElement sin = (CalculusFieldElement)tanTheta.multiply((FieldElement)cos);
        CalculusFieldElement invDenom = (CalculusFieldElement)((CalculusFieldElement)gamma.linearCombination((FieldElement)gamma, (FieldElement)gamma, (FieldElement)((CalculusFieldElement)alpha.negate()), (FieldElement)beta)).reciprocal();
        CalculusFieldElement tauC = (CalculusFieldElement)((CalculusFieldElement)gamma.linearCombination((FieldElement)beta, (FieldElement)delta, (FieldElement)((CalculusFieldElement)gamma.negate()), (FieldElement)epsilon)).multiply((FieldElement)invDenom);
        CalculusFieldElement nuC = (CalculusFieldElement)((CalculusFieldElement)gamma.linearCombination((FieldElement)alpha, (FieldElement)epsilon, (FieldElement)((CalculusFieldElement)gamma.negate()), (FieldElement)delta)).multiply((FieldElement)invDenom);
        CalculusFieldElement twogcs = (CalculusFieldElement)((CalculusFieldElement)gamma.multiply((FieldElement)cosSin)).multiply(2);
        CalculusFieldElement bigA = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)alpha.multiply((FieldElement)cos2)).add((FieldElement)((CalculusFieldElement)beta.multiply((FieldElement)sin2)))).add((FieldElement)twogcs);
        CalculusFieldElement bigB = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)alpha.multiply((FieldElement)sin2)).add((FieldElement)((CalculusFieldElement)beta.multiply((FieldElement)cos2)))).subtract((FieldElement)twogcs);
        CalculusFieldElement bigFN = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)alpha.multiply((FieldElement)tauC)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)gamma.multiply((FieldElement)nuC)).add((FieldElement)delta)).multiply(2)))).multiply((FieldElement)tauC)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.multiply((FieldElement)nuC)).add((FieldElement)((CalculusFieldElement)epsilon.multiply(2)))).multiply((FieldElement)nuC)))).add((FieldElement)zeta)).negate();
        CalculusFieldElement l = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)bigFN.divide((FieldElement)bigA)));
        if (((CalculusFieldElement)l.add((FieldElement)(m = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)bigFN.divide((FieldElement)bigB)))))).isNaN()) {
            return null;
        }
        if (((CalculusFieldElement)l.subtract((FieldElement)m)).getReal() > 0.0) {
            return new FieldEllipse<CalculusFieldElement>(new FieldVector3D((CalculusFieldElement)tauC.getField().getOne(), planePoint, tauC, u, nuC, v), new FieldVector3D(cos, u, sin, v), new FieldVector3D((CalculusFieldElement)sin.negate(), u, cos, v), l, m, this.frame);
        }
        return new FieldEllipse<CalculusFieldElement>(new FieldVector3D((CalculusFieldElement)tauC.getField().getOne(), planePoint, tauC, u, nuC, v), new FieldVector3D(sin, u, (CalculusFieldElement)cos.negate(), v), new FieldVector3D(cos, u, sin, v), m, l, this.frame);
    }

    public Vector3D pointOnLimb(Vector3D observer, Vector3D outside) throws MathRuntimeException {
        double ypt2;
        double ypt1;
        double xpt2;
        double xpt1;
        double s;
        if (this.isInside(observer)) {
            throw new OrekitException((Localizable)OrekitMessages.POINT_INSIDE_ELLIPSOID, new Object[0]);
        }
        Vector3D normal = Vector3D.crossProduct((Vector3D)observer, (Vector3D)outside);
        Ellipse section = this.getPlaneSection(Vector3D.ZERO, normal);
        Vector2D observer2D = section.toPlane(observer);
        double ap = section.getA();
        double bp = section.getB();
        double xpo = observer2D.getX() / ap;
        double ypo = observer2D.getY() / bp;
        double xpo2 = xpo * xpo;
        double ypo2 = ypo * ypo;
        double alphap = ypo2 + xpo2;
        double gammap = 1.0 - ypo2;
        double sqrt = FastMath.sqrt((double)(alphap - 1.0));
        double sqrtp = FastMath.abs((double)ypo) * sqrt;
        double sqrtSigned = FastMath.copySign((double)sqrt, (double)ypo);
        if (xpo > 0.0) {
            s = xpo + sqrtp;
            xpt1 = s / alphap;
            xpt2 = gammap / s;
            ypt1 = (ypo - xpo * sqrtSigned) / alphap;
            ypt2 = (xpo * ypo + sqrtSigned) / s;
        } else {
            s = xpo - sqrtp;
            xpt1 = gammap / s;
            xpt2 = s / alphap;
            ypt2 = (ypo + xpo * sqrtSigned) / alphap;
            ypt1 = (xpo * ypo - sqrtSigned) / s;
        }
        Vector3D tp1 = section.toSpace(new Vector2D(ap * xpt1, bp * ypt1));
        Vector3D tp2 = section.toSpace(new Vector2D(ap * xpt2, bp * ypt2));
        return Vector3D.distance((Vector3D)tp1, (Vector3D)outside) <= Vector3D.distance((Vector3D)tp2, (Vector3D)outside) ? tp1 : tp2;
    }

    public <T extends CalculusFieldElement<T>> FieldVector3D<T> pointOnLimb(FieldVector3D<T> observer, FieldVector3D<T> outside) throws MathRuntimeException {
        CalculusFieldElement ypt2;
        CalculusFieldElement ypt1;
        CalculusFieldElement xpt2;
        CalculusFieldElement xpt1;
        CalculusFieldElement s;
        if (this.isInside(observer)) {
            throw new OrekitException((Localizable)OrekitMessages.POINT_INSIDE_ELLIPSOID, new Object[0]);
        }
        FieldVector3D normal = FieldVector3D.crossProduct(observer, outside);
        FieldEllipse<T> section = this.getPlaneSection(FieldVector3D.getZero((Field)observer.getX().getField()), normal);
        FieldVector2D<T> observer2D = section.toPlane(observer);
        T ap = section.getA();
        T bp = section.getB();
        CalculusFieldElement xpo = (CalculusFieldElement)observer2D.getX().divide(ap);
        CalculusFieldElement ypo = (CalculusFieldElement)observer2D.getY().divide(bp);
        CalculusFieldElement xpo2 = (CalculusFieldElement)xpo.multiply((FieldElement)xpo);
        CalculusFieldElement ypo2 = (CalculusFieldElement)ypo.multiply((FieldElement)ypo);
        CalculusFieldElement alphap = (CalculusFieldElement)ypo2.add((FieldElement)xpo2);
        CalculusFieldElement gammap = (CalculusFieldElement)((CalculusFieldElement)ypo2.negate()).add(1.0);
        CalculusFieldElement sqrt = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)alphap.subtract(1.0)));
        CalculusFieldElement sqrtp = (CalculusFieldElement)FastMath.abs((CalculusFieldElement)ypo).multiply((FieldElement)sqrt);
        CalculusFieldElement sqrtSigned = FastMath.copySign((CalculusFieldElement)sqrt, (CalculusFieldElement)ypo);
        if (xpo.getReal() > 0.0) {
            s = (CalculusFieldElement)xpo.add((FieldElement)sqrtp);
            xpt1 = (CalculusFieldElement)s.divide((FieldElement)alphap);
            xpt2 = (CalculusFieldElement)gammap.divide((FieldElement)s);
            ypt1 = (CalculusFieldElement)((CalculusFieldElement)ypo.subtract((FieldElement)((CalculusFieldElement)xpo.multiply((FieldElement)sqrtSigned)))).divide((FieldElement)alphap);
            ypt2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)xpo.multiply((FieldElement)ypo)).add((FieldElement)sqrtSigned)).divide((FieldElement)s);
        } else {
            s = (CalculusFieldElement)xpo.subtract((FieldElement)sqrtp);
            xpt1 = (CalculusFieldElement)gammap.divide((FieldElement)s);
            xpt2 = (CalculusFieldElement)s.divide((FieldElement)alphap);
            ypt2 = (CalculusFieldElement)((CalculusFieldElement)ypo.add((FieldElement)((CalculusFieldElement)xpo.multiply((FieldElement)sqrtSigned)))).divide((FieldElement)alphap);
            ypt1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)xpo.multiply((FieldElement)ypo)).subtract((FieldElement)sqrtSigned)).divide((FieldElement)s);
        }
        FieldVector3D<T> tp1 = section.toSpace(new FieldVector2D((CalculusFieldElement)ap.multiply((FieldElement)xpt1), (CalculusFieldElement)bp.multiply((FieldElement)ypt1)));
        FieldVector3D<T> tp2 = section.toSpace(new FieldVector2D((CalculusFieldElement)ap.multiply((FieldElement)xpt2), (CalculusFieldElement)bp.multiply((FieldElement)ypt2)));
        return ((CalculusFieldElement)FieldVector3D.distance(tp1, outside).subtract((FieldElement)FieldVector3D.distance(tp2, outside))).getReal() <= 0.0 ? tp1 : tp2;
    }
}

