/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.AllowedSolution;
import org.hipparchus.analysis.solvers.BracketingNthOrderBrentSolver;
import org.hipparchus.analysis.solvers.UnivariateSolverUtils;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.CelestialBody;
import org.orekit.frames.CR3BPRotatingFrame;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.AbsolutePVCoordinates;
import org.orekit.utils.LagrangianPoints;
import org.orekit.utils.PVCoordinates;

public class CR3BPSystem {
    private static final double RELATIVE_ACCURACY = 1.0E-14;
    private static final double ABSOLUTE_ACCURACY = 0.001;
    private static final double FUNCTION_ACCURACY = 0.0;
    private static final int MAX_ORDER = 5;
    private static final int MAX_EVALUATIONS = 10000;
    private final double mu;
    private final double dDim;
    private final double vDim;
    private final double tDim;
    private final String name;
    private final Frame rotatingFrame;
    private final CelestialBody primaryBody;
    private final CelestialBody secondaryBody;
    private Vector3D l1Position;
    private Vector3D l2Position;
    private Vector3D l3Position;
    private Vector3D l4Position;
    private Vector3D l5Position;
    private final double gamma1;
    private final double gamma2;
    private final double gamma3;

    public CR3BPSystem(CelestialBody primaryBody, CelestialBody secondaryBody, double a) {
        this(primaryBody, secondaryBody, a, secondaryBody.getGM() / (secondaryBody.getGM() + primaryBody.getGM()));
    }

    public CR3BPSystem(CelestialBody primaryBody, CelestialBody secondaryBody, double a, double mu) {
        this.primaryBody = primaryBody;
        this.secondaryBody = secondaryBody;
        this.name = primaryBody.getName() + "_" + secondaryBody.getName();
        double mu1 = primaryBody.getGM();
        this.mu = mu;
        this.dDim = a;
        this.vDim = FastMath.sqrt((double)(mu1 / this.dDim));
        this.tDim = Math.PI * 2 * this.dDim / this.vDim;
        this.rotatingFrame = new CR3BPRotatingFrame(mu, primaryBody, secondaryBody);
        this.computeLagrangianPointsPosition();
        double x1 = this.l1Position.getX();
        double dCP1 = 1.0 - mu;
        this.gamma1 = dCP1 - x1;
        double x2 = this.l2Position.getX();
        double dCP2 = 1.0 - mu;
        this.gamma2 = x2 - dCP2;
        double x3 = this.l3Position.getX();
        double dCP3 = -mu;
        this.gamma3 = dCP3 - x3;
    }

    private void computeLagrangianPointsPosition() {
        BracketingNthOrderBrentSolver solver = new BracketingNthOrderBrentSolver(1.0E-14, 0.001, 0.0, 5);
        double baseR1 = 1.0 - FastMath.cbrt((double)(this.mu / 3.0));
        UnivariateFunction l1Equation = x -> {
            double leq1 = x * (x + this.mu) * (x + this.mu) * (x + this.mu - 1.0) * (x + this.mu - 1.0);
            double leq2 = (1.0 - this.mu) * (x + this.mu - 1.0) * (x + this.mu - 1.0);
            double leq3 = this.mu * (x + this.mu) * (x + this.mu);
            return leq1 - leq2 + leq3;
        };
        double[] searchInterval1 = UnivariateSolverUtils.bracket((UnivariateFunction)l1Equation, (double)baseR1, (double)(-this.mu), (double)(1.0 - this.mu), (double)1.0E-6, (double)1.0, (int)10000);
        double r1 = solver.solve(10000, l1Equation, searchInterval1[0], searchInterval1[1], AllowedSolution.ANY_SIDE);
        this.l1Position = new Vector3D(r1, 0.0, 0.0);
        double baseR2 = 1.0 + FastMath.cbrt((double)(this.mu / 3.0));
        UnivariateFunction l2Equation = x -> {
            double leq21 = x * (x + this.mu) * (x + this.mu) * (x + this.mu - 1.0) * (x + this.mu - 1.0);
            double leq22 = (1.0 - this.mu) * (x + this.mu - 1.0) * (x + this.mu - 1.0);
            double leq23 = this.mu * (x + this.mu) * (x + this.mu);
            return leq21 - leq22 - leq23;
        };
        double[] searchInterval2 = UnivariateSolverUtils.bracket((UnivariateFunction)l2Equation, (double)baseR2, (double)(1.0 - this.mu), (double)2.0, (double)1.0E-6, (double)1.0, (int)10000);
        double r2 = solver.solve(10000, l2Equation, searchInterval2[0], searchInterval2[1], AllowedSolution.ANY_SIDE);
        this.l2Position = new Vector3D(r2, 0.0, 0.0);
        double baseR3 = -(1.0 + 5.0 * this.mu / 12.0);
        UnivariateFunction l3Equation = x -> {
            double leq31 = x * (x + this.mu) * (x + this.mu) * (x + this.mu - 1.0) * (x + this.mu - 1.0);
            double leq32 = (1.0 - this.mu) * (x + this.mu - 1.0) * (x + this.mu - 1.0);
            double leq33 = this.mu * (x + this.mu) * (x + this.mu);
            return leq31 + leq32 + leq33;
        };
        double[] searchInterval3 = UnivariateSolverUtils.bracket((UnivariateFunction)l3Equation, (double)baseR3, (double)-2.0, (double)(-this.mu), (double)1.0E-6, (double)1.0, (int)10000);
        double r3 = solver.solve(10000, l3Equation, searchInterval3[0], searchInterval3[1], AllowedSolution.ANY_SIDE);
        this.l3Position = new Vector3D(r3, 0.0, 0.0);
        this.l4Position = new Vector3D(0.5 - this.mu, FastMath.sqrt((double)3.0) / 2.0, 0.0);
        this.l5Position = new Vector3D(0.5 - this.mu, -FastMath.sqrt((double)3.0) / 2.0, 0.0);
    }

    public double getMassRatio() {
        return this.mu;
    }

    public double getDdim() {
        return this.dDim;
    }

    public double getVdim() {
        return this.vDim;
    }

    public double getTdim() {
        return this.tDim;
    }

    public String getName() {
        return this.name;
    }

    public CelestialBody getPrimary() {
        return this.primaryBody;
    }

    public CelestialBody getSecondary() {
        return this.secondaryBody;
    }

    public Frame getRotatingFrame() {
        return this.rotatingFrame;
    }

    public Vector3D getLPosition(LagrangianPoints lagrangianPoint) {
        Vector3D lPosition;
        switch (lagrangianPoint) {
            case L1: {
                lPosition = this.l1Position;
                break;
            }
            case L3: {
                lPosition = this.l3Position;
                break;
            }
            case L4: {
                lPosition = this.l4Position;
                break;
            }
            case L5: {
                lPosition = this.l5Position;
                break;
            }
            default: {
                lPosition = this.l2Position;
            }
        }
        return lPosition;
    }

    public double getGamma(LagrangianPoints lagrangianPoint) {
        double gamma;
        switch (lagrangianPoint) {
            case L1: {
                gamma = this.gamma1;
                break;
            }
            case L2: {
                gamma = this.gamma2;
                break;
            }
            case L3: {
                gamma = this.gamma3;
                break;
            }
            default: {
                gamma = 0.0;
            }
        }
        return gamma;
    }

    private PVCoordinates getRealPV(PVCoordinates pv0, AbsoluteDate date, Frame outputFrame) {
        Frame primaryInertialFrame = this.primaryBody.getInertiallyOrientedFrame();
        Vector3D pv21 = this.secondaryBody.getPosition(date, primaryInertialFrame);
        double dist12 = pv21.getNorm();
        double vCircular = FastMath.sqrt((double)(this.primaryBody.getGM() / dist12));
        PVCoordinates pvDim = new PVCoordinates(pv0.getPosition().scalarMultiply(dist12), pv0.getVelocity().scalarMultiply(vCircular));
        Transform rotatingToPrimaryInertial = this.rotatingFrame.getTransformTo(primaryInertialFrame, date);
        PVCoordinates pv2 = rotatingToPrimaryInertial.transformPVCoordinates(pvDim);
        Transform primaryInertialToOutputFrame = primaryInertialFrame.getTransformTo(outputFrame, date);
        return primaryInertialToOutputFrame.transformPVCoordinates(pv2);
    }

    public AbsolutePVCoordinates getRealAPV(AbsolutePVCoordinates apv0, AbsoluteDate initialDate, Frame outputFrame) {
        double duration = apv0.getDate().durationFrom(initialDate) * this.tDim / (Math.PI * 2);
        AbsoluteDate date = initialDate.shiftedBy(duration);
        PVCoordinates pv3 = this.getRealPV(apv0.getPVCoordinates(), date, outputFrame);
        return new AbsolutePVCoordinates(outputFrame, date, pv3);
    }
}

