/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.SinCos;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.frames.FieldStaticTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.StaticTransform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.ExtendedPositionProvider;

public class AnalyticalSolarPositionProvider
implements ExtendedPositionProvider {
    private static final SinCos SIN_COS_ECLIPTIC_ANGLE_EME2000 = FastMath.sinCos((double)FastMath.toRadians((double)23.43929111));
    private static final double INTERMEDIATE_ANGLE = FastMath.toRadians((double)282.94);
    private final Frame eme2000;
    private final TimeScale timeScale;

    public AnalyticalSolarPositionProvider(DataContext dataContext) {
        this.eme2000 = dataContext.getFrames().getEME2000();
        this.timeScale = dataContext.getTimeScales().getUTC();
    }

    @DefaultDataContext
    public AnalyticalSolarPositionProvider() {
        this(DataContext.getDefault());
    }

    @Override
    public Vector3D getPosition(AbsoluteDate date, Frame frame) {
        Vector3D eme2000Position = this.getEME2000Position(date);
        if (frame.equals(this.eme2000)) {
            return eme2000Position;
        }
        StaticTransform transform = this.eme2000.getStaticTransformTo(frame, date);
        return transform.transformPosition(eme2000Position);
    }

    private Vector3D getEME2000Position(AbsoluteDate date) {
        double tt = (date.getJD(this.timeScale) - 2451545.0) / 36525.0;
        double M = FastMath.toRadians((double)(357.5256 + 35999.049 * tt));
        SinCos sinCosM = FastMath.sinCos((double)M);
        SinCos sinCos2M = FastMath.sinCos((double)(2.0 * M));
        double r = (149.619 - 2.499 * sinCosM.cos() - 0.021 * sinCos2M.cos()) * 1.0E9;
        double lambda = INTERMEDIATE_ANGLE + M + FastMath.toRadians((double)(6892.0 * sinCosM.sin() + 72.0 * sinCos2M.sin())) / 3600.0;
        SinCos sinCosLambda = FastMath.sinCos((double)lambda);
        return new Vector3D(r * sinCosLambda.cos(), r * sinCosLambda.sin() * SIN_COS_ECLIPTIC_ANGLE_EME2000.cos(), r * sinCosLambda.sin() * SIN_COS_ECLIPTIC_ANGLE_EME2000.sin());
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> getPosition(FieldAbsoluteDate<T> date, Frame frame) {
        FieldVector3D<T> eme2000Position = this.getFieldEME2000Position(date);
        if (frame.equals(this.eme2000)) {
            return eme2000Position;
        }
        FieldStaticTransform<T> transform = this.eme2000.getStaticTransformTo(frame, date);
        return transform.transformPosition(eme2000Position);
    }

    private <T extends CalculusFieldElement<T>> FieldVector3D<T> getFieldEME2000Position(FieldAbsoluteDate<T> date) {
        CalculusFieldElement tt = (CalculusFieldElement)((CalculusFieldElement)date.getJD(this.timeScale).subtract(2451545.0)).divide(36525.0);
        CalculusFieldElement M = FastMath.toRadians((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)tt.multiply(35999.049)).add(357.5256)));
        FieldSinCos sinCosM = FastMath.sinCos((CalculusFieldElement)M);
        FieldSinCos sinCos2M = FastMath.sinCos((CalculusFieldElement)((CalculusFieldElement)M.multiply(2)));
        CalculusFieldElement r = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinCosM.cos()).multiply(-2.499)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinCos2M.cos()).multiply(0.021)))).add(149.619)).multiply(1.0E9);
        CalculusFieldElement lambda = (CalculusFieldElement)((CalculusFieldElement)M.add(INTERMEDIATE_ANGLE)).add((FieldElement)FastMath.toRadians((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinCosM.sin()).multiply(6892.0)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinCos2M.sin()).multiply(72.0)))).divide(3600.0))));
        FieldSinCos sinCosLambda = FastMath.sinCos((CalculusFieldElement)lambda);
        return new FieldVector3D((CalculusFieldElement)r.multiply((FieldElement)((CalculusFieldElement)sinCosLambda.cos())), (CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)((CalculusFieldElement)sinCosLambda.sin()))).multiply(SIN_COS_ECLIPTIC_ANGLE_EME2000.cos()), (CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)((CalculusFieldElement)sinCosLambda.sin()))).multiply(SIN_COS_ECLIPTIC_ANGLE_EME2000.sin()));
    }
}

