/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProviderModifier;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.attitudes.GroundPointing;
import org.orekit.attitudes.GroundPointingAttitudeModifier;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class YawCompensation
extends GroundPointingAttitudeModifier
implements AttitudeProviderModifier {
    private static final PVCoordinates PLUS_J = new PVCoordinates(Vector3D.PLUS_J, Vector3D.ZERO, Vector3D.ZERO);
    private static final PVCoordinates PLUS_K = new PVCoordinates(Vector3D.PLUS_K, Vector3D.ZERO, Vector3D.ZERO);

    public YawCompensation(Frame inertialFrame, GroundPointing groundPointingLaw) {
        super(inertialFrame, groundPointingLaw.getBodyFrame(), groundPointingLaw);
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        Transform bodyToRef = this.getBodyFrame().getTransformTo(frame, date);
        TimeStampedPVCoordinates slidingRef = this.getTargetPV(pvProv, date, frame);
        PVCoordinates slidingBody = bodyToRef.getInverse().transformPVCoordinates((PVCoordinates)slidingRef);
        PVCoordinates relativePosition = new PVCoordinates(pvProv.getPVCoordinates(date, frame), (PVCoordinates)slidingRef);
        Vector3D v = bodyToRef.getRotation().applyTo(slidingBody.getVelocity());
        Vector3D a = new Vector3D(1.0, bodyToRef.getRotation().applyTo(slidingBody.getAcceleration()), -1.0, Vector3D.crossProduct((Vector3D)bodyToRef.getRotationRate(), (Vector3D)v));
        PVCoordinates relativeVelocity = new PVCoordinates(v, a, Vector3D.ZERO);
        PVCoordinates relativeNormal = PVCoordinates.crossProduct(relativePosition, relativeVelocity).normalize();
        return new Attitude(frame, new TimeStampedAngularCoordinates(date, relativePosition.normalize(), relativeNormal.normalize(), PLUS_K, PLUS_J, 1.0E-9));
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        Field<T> field = date.getField();
        FieldVector3D zero = FieldVector3D.getZero(field);
        FieldPVCoordinates plusJ = new FieldPVCoordinates(FieldVector3D.getPlusJ(field), zero, zero);
        FieldPVCoordinates plusK = new FieldPVCoordinates(FieldVector3D.getPlusK(field), zero, zero);
        FieldTransform<T> bodyToRef = this.getBodyFrame().getTransformTo(frame, date);
        TimeStampedFieldPVCoordinates<T> slidingRef = this.getTargetPV(pvProv, date, frame);
        FieldPVCoordinates<T> slidingBody = ((FieldTransform)bodyToRef.getInverse()).transformPVCoordinates(slidingRef);
        FieldPVCoordinates relativePosition = new FieldPVCoordinates(pvProv.getPVCoordinates(date, frame), slidingRef);
        FieldVector3D v = bodyToRef.getRotation().applyTo(slidingBody.getVelocity());
        FieldVector3D a = new FieldVector3D(1.0, bodyToRef.getRotation().applyTo(slidingBody.getAcceleration()), -1.0, FieldVector3D.crossProduct(bodyToRef.getRotationRate(), (FieldVector3D)v));
        FieldPVCoordinates relativeVelocity = new FieldPVCoordinates(v, a, FieldVector3D.getZero(date.getField()));
        FieldPVCoordinates<T> relativeNormal = relativePosition.crossProduct(relativeVelocity).normalize();
        return new FieldAttitude<T>(frame, new TimeStampedFieldAngularCoordinates<T>(date, relativePosition.normalize(), relativeNormal.normalize(), plusK, plusJ, 1.0E-9));
    }

    public double getYawAngle(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        Rotation rBase = this.getBaseState(pvProv, date, frame).getRotation();
        Rotation rCompensated = this.getAttitude(pvProv, date, frame).getRotation();
        Rotation compensation = rCompensated.compose(rBase.revert(), RotationConvention.VECTOR_OPERATOR);
        return -compensation.applyTo(Vector3D.PLUS_I).getAlpha();
    }

    public <T extends CalculusFieldElement<T>> T getYawAngle(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        FieldRotation<T> rBase = this.getBaseState(pvProv, date, frame).getRotation();
        FieldRotation<T> rCompensated = this.getAttitude(pvProv, date, frame).getRotation();
        FieldRotation compensation = rCompensated.compose(rBase.revert(), RotationConvention.VECTOR_OPERATOR);
        return (T)((CalculusFieldElement)compensation.applyTo(Vector3D.PLUS_I).getAlpha().negate());
    }
}

