/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import java.util.HashMap;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.ode.DenseOutputModel;
import org.hipparchus.ode.FieldDenseOutputModel;
import org.hipparchus.ode.FieldExpandableODE;
import org.hipparchus.ode.FieldODEState;
import org.hipparchus.ode.FieldOrdinaryDifferentialEquation;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.OrdinaryDifferentialEquation;
import org.hipparchus.ode.nonstiff.DormandPrince853FieldIntegrator;
import org.hipparchus.ode.nonstiff.DormandPrince853Integrator;
import org.hipparchus.ode.sampling.FieldODEStepHandler;
import org.hipparchus.ode.sampling.ODEStepHandler;
import org.hipparchus.special.elliptic.jacobi.CopolarN;
import org.hipparchus.special.elliptic.jacobi.FieldCopolarN;
import org.hipparchus.special.elliptic.jacobi.FieldJacobiElliptic;
import org.hipparchus.special.elliptic.jacobi.JacobiElliptic;
import org.hipparchus.special.elliptic.jacobi.JacobiEllipticBuilder;
import org.hipparchus.special.elliptic.legendre.LegendreEllipticIntegral;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.attitudes.FieldInertia;
import org.orekit.attitudes.FieldInertiaAxis;
import org.orekit.attitudes.Inertia;
import org.orekit.attitudes.InertiaAxis;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class TorqueFree
implements AttitudeProvider {
    private final Attitude initialAttitude;
    private final Inertia inertia;
    private final DoubleModel doubleModel;
    private final transient Map<Field<? extends CalculusFieldElement<?>>, FieldModel<? extends CalculusFieldElement<?>>> cachedModels;

    public TorqueFree(Attitude initialAttitude, Inertia inertia) {
        this.initialAttitude = initialAttitude;
        this.inertia = inertia;
        this.doubleModel = new DoubleModel();
        this.cachedModels = new HashMap();
    }

    public Attitude getInitialAttitude() {
        return this.initialAttitude;
    }

    public Inertia getInertia() {
        return this.inertia;
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        Attitude attitude = new Attitude(this.initialAttitude.getReferenceFrame(), this.doubleModel.evaluate(date));
        return attitude.withReferenceFrame(frame);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        FieldModel<Object> fm = this.cachedModels.get(date.getField());
        if (fm == null) {
            fm = new FieldModel<T>(date.getField());
            this.cachedModels.put(date.getField(), fm);
        }
        FieldAttitude attitude = new FieldAttitude(this.initialAttitude.getReferenceFrame(), fm.evaluate(date));
        return attitude.withReferenceFrame(frame);
    }

    private class FieldModel<T extends CalculusFieldElement<T>> {
        private final FieldInertia<T> sortedInertia;
        private final T o1Scale;
        private final T o2Scale;
        private final T o3Scale;
        private final FieldJacobiElliptic<T> jacobi;
        private final T tScale;
        private final FieldAbsoluteDate<T> tRef;
        private final FieldRotation<T> inertToAligned;
        private final FieldRotation<T> sortedToBody;
        private final T period;
        private final T phiSlope;
        private final FieldDenseOutputModel<T> phiQuadratureModel;
        private final T integOnePeriod;

        FieldModel(Field<T> field) {
            boolean clockwise;
            CalculusFieldElement separatrixInertia;
            double i1 = TorqueFree.this.inertia.getInertiaAxis1().getI();
            Vector3D a1 = TorqueFree.this.inertia.getInertiaAxis1().getA();
            double i2 = TorqueFree.this.inertia.getInertiaAxis2().getI();
            Vector3D a2 = TorqueFree.this.inertia.getInertiaAxis2().getA();
            double i3 = TorqueFree.this.inertia.getInertiaAxis3().getI();
            Vector3D a3 = TorqueFree.this.inertia.getInertiaAxis3().getA();
            CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
            CalculusFieldElement fI1 = (CalculusFieldElement)zero.newInstance(i1);
            FieldVector3D fA1 = new FieldVector3D(field, a1);
            CalculusFieldElement fI2 = (CalculusFieldElement)zero.newInstance(i2);
            FieldVector3D fA2 = new FieldVector3D(field, a2);
            CalculusFieldElement fI3 = (CalculusFieldElement)zero.newInstance(i3);
            FieldVector3D fA3 = new FieldVector3D(field, a3);
            FieldVector3D n1 = fA1.normalize();
            FieldVector3D n2 = fA2.normalize();
            FieldVector3D n3 = Vector3D.dotProduct((Vector3D)Vector3D.crossProduct((Vector3D)a1, (Vector3D)a2), (Vector3D)a3) > 0.0 ? fA3.normalize() : fA3.normalize().negate();
            FieldVector3D omega0 = new FieldVector3D(field, TorqueFree.this.initialAttitude.getSpin());
            FieldVector3D m0 = new FieldVector3D((CalculusFieldElement)fI1.multiply((FieldElement)FieldVector3D.dotProduct((FieldVector3D)omega0, (FieldVector3D)n1)), n1, (CalculusFieldElement)fI2.multiply((FieldElement)FieldVector3D.dotProduct((FieldVector3D)omega0, (FieldVector3D)n2)), n2, (CalculusFieldElement)fI3.multiply((FieldElement)FieldVector3D.dotProduct((FieldVector3D)omega0, (FieldVector3D)n3)), n3);
            FieldInertia<CalculusFieldElement> tmpInertia = new FieldInertia<CalculusFieldElement>(new FieldInertiaAxis<CalculusFieldElement>(fI1, n1), new FieldInertiaAxis<CalculusFieldElement>(fI2, n2), new FieldInertiaAxis<CalculusFieldElement>(fI3, n3));
            if (((CalculusFieldElement)tmpInertia.getInertiaAxis1().getI().subtract((FieldElement)tmpInertia.getInertiaAxis2().getI())).getReal() > 0.0) {
                tmpInertia = tmpInertia.swap12();
            }
            if (((CalculusFieldElement)tmpInertia.getInertiaAxis2().getI().subtract((FieldElement)tmpInertia.getInertiaAxis3().getI())).getReal() > 0.0) {
                tmpInertia = tmpInertia.swap23();
            }
            if (((CalculusFieldElement)tmpInertia.getInertiaAxis1().getI().subtract((FieldElement)tmpInertia.getInertiaAxis2().getI())).getReal() > 0.0) {
                tmpInertia = tmpInertia.swap12();
            }
            CalculusFieldElement o1 = FieldVector3D.dotProduct((FieldVector3D)omega0, (FieldVector3D)n1);
            CalculusFieldElement o2 = FieldVector3D.dotProduct((FieldVector3D)omega0, (FieldVector3D)n2);
            CalculusFieldElement o3 = FieldVector3D.dotProduct((FieldVector3D)omega0, (FieldVector3D)n3);
            CalculusFieldElement o12 = (CalculusFieldElement)o1.square();
            CalculusFieldElement o22 = (CalculusFieldElement)o2.square();
            CalculusFieldElement o32 = (CalculusFieldElement)o3.square();
            CalculusFieldElement twoE = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)fI1.multiply((FieldElement)o12)).add((FieldElement)((CalculusFieldElement)fI2.multiply((FieldElement)o22)))).add((FieldElement)((CalculusFieldElement)fI3.multiply((FieldElement)o32)));
            CalculusFieldElement m2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)fI1.square()).multiply((FieldElement)o12)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)fI2.square()).multiply((FieldElement)o22)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)fI3.square()).multiply((FieldElement)o32)));
            CalculusFieldElement calculusFieldElement = separatrixInertia = twoE.isZero() ? zero : (CalculusFieldElement)m2.divide((FieldElement)twoE);
            if (((CalculusFieldElement)separatrixInertia.subtract((FieldElement)tmpInertia.getInertiaAxis2().getI())).getReal() < 0.0) {
                clockwise = true;
                tmpInertia = tmpInertia.swap13();
            } else {
                clockwise = false;
            }
            this.sortedInertia = tmpInertia;
            CalculusFieldElement i1C = tmpInertia.getInertiaAxis1().getI();
            CalculusFieldElement i2C = tmpInertia.getInertiaAxis2().getI();
            CalculusFieldElement i3C = tmpInertia.getInertiaAxis3().getI();
            CalculusFieldElement i32 = (CalculusFieldElement)i3C.subtract((FieldElement)i2C);
            CalculusFieldElement i31 = (CalculusFieldElement)i3C.subtract((FieldElement)i1C);
            CalculusFieldElement i21 = (CalculusFieldElement)i2C.subtract((FieldElement)i1C);
            this.sortedToBody = new FieldRotation(FieldVector3D.getPlusI(field), FieldVector3D.getPlusJ(field), tmpInertia.getInertiaAxis1().getA(), tmpInertia.getInertiaAxis2().getA());
            FieldVector3D omega0Sorted = this.sortedToBody.applyInverseTo(omega0);
            FieldVector3D m0Sorted = this.sortedToBody.applyInverseTo(m0);
            CalculusFieldElement phi0 = zero;
            CalculusFieldElement theta0 = FastMath.acos((CalculusFieldElement)((CalculusFieldElement)m0Sorted.getZ().divide((FieldElement)m0Sorted.getNorm())));
            CalculusFieldElement psi0 = FastMath.atan2((CalculusFieldElement)m0Sorted.getX(), (CalculusFieldElement)m0Sorted.getY());
            FieldRotation alignedToSorted0 = new FieldRotation(RotationOrder.ZXZ, RotationConvention.FRAME_TRANSFORM, phi0, theta0, psi0);
            this.inertToAligned = alignedToSorted0.applyInverseTo(this.sortedToBody.applyInverseTo(new FieldRotation(field, TorqueFree.this.initialAttitude.getRotation())));
            this.tScale = FastMath.copySign((CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)i32.multiply((FieldElement)((CalculusFieldElement)m2.subtract((FieldElement)((CalculusFieldElement)twoE.multiply((FieldElement)i1C)))))).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)i1C.multiply((FieldElement)i2C)).multiply((FieldElement)i3C))))), (CalculusFieldElement)(clockwise ? (CalculusFieldElement)omega0Sorted.getZ().negate() : omega0Sorted.getZ()));
            this.o1Scale = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)twoE.multiply((FieldElement)i3C)).subtract((FieldElement)m2)).divide((FieldElement)((CalculusFieldElement)i1C.multiply((FieldElement)i31)))));
            this.o2Scale = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)twoE.multiply((FieldElement)i3C)).subtract((FieldElement)m2)).divide((FieldElement)((CalculusFieldElement)i2C.multiply((FieldElement)i32)))));
            this.o3Scale = FastMath.copySign((CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m2.subtract((FieldElement)((CalculusFieldElement)twoE.multiply((FieldElement)i1C)))).divide((FieldElement)((CalculusFieldElement)i3C.multiply((FieldElement)i31))))), (CalculusFieldElement)omega0Sorted.getZ());
            CalculusFieldElement k2 = twoE.isZero() ? zero : (CalculusFieldElement)((CalculusFieldElement)i21.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)twoE.multiply((FieldElement)i3C)).subtract((FieldElement)m2)))).divide((FieldElement)((CalculusFieldElement)i32.multiply((FieldElement)((CalculusFieldElement)m2.subtract((FieldElement)((CalculusFieldElement)twoE.multiply((FieldElement)i1C)))))));
            this.jacobi = JacobiEllipticBuilder.build((CalculusFieldElement)k2);
            this.period = (CalculusFieldElement)((CalculusFieldElement)LegendreEllipticIntegral.bigK((CalculusFieldElement)k2).multiply(4)).divide(this.tScale);
            CalculusFieldElement dtRef = this.o1Scale.isZero() ? zero : (((CalculusFieldElement)FastMath.abs((CalculusFieldElement)omega0Sorted.getX()).subtract((FieldElement)FastMath.abs((CalculusFieldElement)omega0Sorted.getY()))).getReal() >= 0.0 ? (omega0Sorted.getX().getReal() >= 0.0 ? (CalculusFieldElement)((CalculusFieldElement)this.jacobi.arcsn((CalculusFieldElement)omega0Sorted.getY().divide(this.o2Scale)).divide(this.tScale)).negate() : (CalculusFieldElement)((CalculusFieldElement)this.jacobi.arcsn((CalculusFieldElement)omega0Sorted.getY().divide(this.o2Scale)).divide(this.tScale)).subtract((FieldElement)((CalculusFieldElement)this.period.multiply(0.5)))) : (omega0Sorted.getY().getReal() >= 0.0 ? (CalculusFieldElement)((CalculusFieldElement)this.jacobi.arccn((CalculusFieldElement)omega0Sorted.getX().divide(this.o1Scale)).divide(this.tScale)).negate() : (CalculusFieldElement)this.jacobi.arccn((CalculusFieldElement)omega0Sorted.getX().divide(this.o1Scale)).divide(this.tScale)));
            this.tRef = new FieldAbsoluteDate<T>(field, TorqueFree.this.initialAttitude.getDate()).shiftedBy(dtRef);
            this.phiSlope = (CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)m2).divide((FieldElement)i3C);
            this.phiQuadratureModel = this.computePhiQuadratureModel(dtRef);
            this.integOnePeriod = this.phiQuadratureModel.getInterpolatedState(this.phiQuadratureModel.getFinalTime()).getPrimaryState()[0];
        }

        private FieldDenseOutputModel<T> computePhiQuadratureModel(T dtRef) {
            CalculusFieldElement zero = (CalculusFieldElement)dtRef.getField().getZero();
            T i1C = this.sortedInertia.getInertiaAxis1().getI();
            T i2C = this.sortedInertia.getInertiaAxis2().getI();
            T i3C = this.sortedInertia.getInertiaAxis3().getI();
            CalculusFieldElement i32 = (CalculusFieldElement)i3C.subtract(i2C);
            CalculusFieldElement i31 = (CalculusFieldElement)i3C.subtract(i1C);
            CalculusFieldElement i21 = (CalculusFieldElement)i2C.subtract(i1C);
            CalculusFieldElement b = (CalculusFieldElement)((CalculusFieldElement)this.phiSlope.multiply((FieldElement)i32)).multiply((FieldElement)i31);
            CalculusFieldElement c = (CalculusFieldElement)i1C.multiply((FieldElement)i32);
            CalculusFieldElement d = (CalculusFieldElement)i3C.multiply((FieldElement)i21);
            DormandPrince853FieldIntegrator integ = new DormandPrince853FieldIntegrator(dtRef.getField(), 1.0E-6 * this.period.getReal(), 0.01 * this.period.getReal(), this.phiSlope.getReal() * this.period.getReal() * 1.0E-13, 1.0E-13);
            FieldDenseOutputModel model = new FieldDenseOutputModel();
            integ.addStepHandler((FieldODEStepHandler)model);
            integ.integrate(new FieldExpandableODE(new FieldOrdinaryDifferentialEquation<T>((CalculusFieldElement)dtRef, b, c, d){
                final /* synthetic */ CalculusFieldElement val$dtRef;
                final /* synthetic */ CalculusFieldElement val$b;
                final /* synthetic */ CalculusFieldElement val$c;
                final /* synthetic */ CalculusFieldElement val$d;
                {
                    this.val$dtRef = calculusFieldElement;
                    this.val$b = calculusFieldElement2;
                    this.val$c = calculusFieldElement3;
                    this.val$d = calculusFieldElement4;
                }

                public int getDimension() {
                    return 1;
                }

                public T[] computeDerivatives(T t, T[] y) {
                    CalculusFieldElement sn = FieldModel.this.jacobi.valuesN((CalculusFieldElement)((CalculusFieldElement)t.subtract((FieldElement)this.val$dtRef)).multiply((FieldElement)FieldModel.this.tScale)).sn();
                    CalculusFieldElement[] yDot = (CalculusFieldElement[])MathArrays.buildArray((Field)this.val$dtRef.getField(), (int)1);
                    yDot[0] = (CalculusFieldElement)this.val$b.divide((FieldElement)((CalculusFieldElement)this.val$c.add((FieldElement)((CalculusFieldElement)this.val$d.multiply((FieldElement)((CalculusFieldElement)sn.square()))))));
                    return yDot;
                }
            }), new FieldODEState(zero, (CalculusFieldElement[])MathArrays.buildArray((Field)dtRef.getField(), (int)1)), this.period);
            return model;
        }

        public TimeStampedFieldAngularCoordinates<T> evaluate(FieldAbsoluteDate<T> date) {
            FieldCopolarN valuesN = this.jacobi.valuesN((CalculusFieldElement)date.durationFrom(this.tRef).multiply(this.tScale));
            FieldVector3D omegaSorted = new FieldVector3D((CalculusFieldElement)valuesN.cn().multiply(this.o1Scale), (CalculusFieldElement)valuesN.sn().multiply(this.o2Scale), (CalculusFieldElement)valuesN.dn().multiply(this.o3Scale));
            FieldVector3D omegaBody = this.sortedToBody.applyTo(omegaSorted);
            FieldVector3D accelerationSorted = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.o1Scale.multiply(this.tScale)).multiply((FieldElement)valuesN.cn())).multiply((FieldElement)valuesN.dn()), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.o2Scale.multiply(this.tScale)).multiply((FieldElement)((CalculusFieldElement)valuesN.sn().negate()))).multiply((FieldElement)valuesN.dn()), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.o3Scale.multiply(this.tScale)).multiply((FieldElement)((CalculusFieldElement)this.jacobi.getM().negate()))).multiply((FieldElement)valuesN.sn())).multiply((FieldElement)valuesN.cn()));
            FieldVector3D accelerationBody = this.sortedToBody.applyTo(accelerationSorted);
            T dt = date.durationFrom(TorqueFree.this.initialAttitude.getDate());
            CalculusFieldElement psi = FastMath.atan2((CalculusFieldElement)((CalculusFieldElement)this.sortedInertia.getInertiaAxis1().getI().multiply((FieldElement)omegaSorted.getX())), (CalculusFieldElement)((CalculusFieldElement)this.sortedInertia.getInertiaAxis2().getI().multiply((FieldElement)omegaSorted.getY())));
            CalculusFieldElement theta = FastMath.acos((CalculusFieldElement)((CalculusFieldElement)omegaSorted.getZ().divide(this.phiSlope)));
            CalculusFieldElement phiLinear = (CalculusFieldElement)dt.multiply(this.phiSlope);
            int nbPeriods = (int)FastMath.floor((CalculusFieldElement)((CalculusFieldElement)dt.divide(this.period))).getReal();
            CalculusFieldElement tStartInteg = (CalculusFieldElement)this.period.multiply(nbPeriods);
            CalculusFieldElement integPartial = this.phiQuadratureModel.getInterpolatedState((CalculusFieldElement)dt.subtract((FieldElement)tStartInteg)).getPrimaryState()[0];
            CalculusFieldElement phiQuadrature = (CalculusFieldElement)((CalculusFieldElement)this.integOnePeriod.multiply(nbPeriods)).add((FieldElement)integPartial);
            CalculusFieldElement phi = (CalculusFieldElement)phiLinear.add((FieldElement)phiQuadrature);
            FieldRotation alignedToSorted = new FieldRotation(RotationOrder.ZXZ, RotationConvention.FRAME_TRANSFORM, phi, theta, psi);
            FieldRotation inertToBody = this.sortedToBody.applyTo(alignedToSorted.applyTo(this.inertToAligned));
            return new TimeStampedFieldAngularCoordinates<T>(date, inertToBody, omegaBody, accelerationBody);
        }
    }

    private class DoubleModel {
        private final Inertia sortedInertia;
        private final double o1Scale;
        private final double o2Scale;
        private final double o3Scale;
        private final JacobiElliptic jacobi;
        private final double tScale;
        private final AbsoluteDate tRef;
        private final Rotation inertToAligned;
        private final Rotation sortedToBody;
        private final double period;
        private final double phiSlope;
        private final DenseOutputModel phiQuadratureModel;
        private final double integOnePeriod;

        DoubleModel() {
            boolean clockwise;
            double separatrixInertia;
            double i1 = TorqueFree.this.inertia.getInertiaAxis1().getI();
            Vector3D a1 = TorqueFree.this.inertia.getInertiaAxis1().getA();
            double i2 = TorqueFree.this.inertia.getInertiaAxis2().getI();
            Vector3D a2 = TorqueFree.this.inertia.getInertiaAxis2().getA();
            double i3 = TorqueFree.this.inertia.getInertiaAxis3().getI();
            Vector3D a3 = TorqueFree.this.inertia.getInertiaAxis3().getA();
            Vector3D n1 = (Vector3D)a1.normalize();
            Vector3D n2 = (Vector3D)a2.normalize();
            Vector3D n3 = Vector3D.dotProduct((Vector3D)Vector3D.crossProduct((Vector3D)a1, (Vector3D)a2), (Vector3D)a3) > 0.0 ? (Vector3D)a3.normalize() : ((Vector3D)a3.normalize()).negate();
            Vector3D omega0 = TorqueFree.this.initialAttitude.getSpin();
            Vector3D m0 = new Vector3D(i1 * Vector3D.dotProduct((Vector3D)omega0, (Vector3D)n1), n1, i2 * Vector3D.dotProduct((Vector3D)omega0, (Vector3D)n2), n2, i3 * Vector3D.dotProduct((Vector3D)omega0, (Vector3D)n3), n3);
            Inertia tmpInertia = new Inertia(new InertiaAxis(i1, n1), new InertiaAxis(i2, n2), new InertiaAxis(i3, n3));
            if (tmpInertia.getInertiaAxis1().getI() > tmpInertia.getInertiaAxis2().getI()) {
                tmpInertia = tmpInertia.swap12();
            }
            if (tmpInertia.getInertiaAxis2().getI() > tmpInertia.getInertiaAxis3().getI()) {
                tmpInertia = tmpInertia.swap23();
            }
            if (tmpInertia.getInertiaAxis1().getI() > tmpInertia.getInertiaAxis2().getI()) {
                tmpInertia = tmpInertia.swap12();
            }
            double o1 = Vector3D.dotProduct((Vector3D)omega0, (Vector3D)n1);
            double o2 = Vector3D.dotProduct((Vector3D)omega0, (Vector3D)n2);
            double o3 = Vector3D.dotProduct((Vector3D)omega0, (Vector3D)n3);
            double o12 = o1 * o1;
            double o22 = o2 * o2;
            double o32 = o3 * o3;
            double twoE = i1 * o12 + i2 * o22 + i3 * o32;
            double m2 = i1 * i1 * o12 + i2 * i2 * o22 + i3 * i3 * o32;
            double d = separatrixInertia = twoE == 0.0 ? 0.0 : m2 / twoE;
            if (separatrixInertia < tmpInertia.getInertiaAxis2().getI()) {
                clockwise = true;
                tmpInertia = tmpInertia.swap13();
            } else {
                clockwise = false;
            }
            this.sortedInertia = tmpInertia;
            double i1C = tmpInertia.getInertiaAxis1().getI();
            double i2C = tmpInertia.getInertiaAxis2().getI();
            double i3C = tmpInertia.getInertiaAxis3().getI();
            double i32 = i3C - i2C;
            double i31 = i3C - i1C;
            double i21 = i2C - i1C;
            this.sortedToBody = new Rotation(Vector3D.PLUS_I, Vector3D.PLUS_J, tmpInertia.getInertiaAxis1().getA(), tmpInertia.getInertiaAxis2().getA());
            Vector3D omega0Sorted = this.sortedToBody.applyInverseTo(omega0);
            Vector3D m0Sorted = this.sortedToBody.applyInverseTo(m0);
            double phi0 = 0.0;
            double theta0 = FastMath.acos((double)(m0Sorted.getZ() / m0Sorted.getNorm()));
            double psi0 = FastMath.atan2((double)m0Sorted.getX(), (double)m0Sorted.getY());
            Rotation alignedToSorted0 = new Rotation(RotationOrder.ZXZ, RotationConvention.FRAME_TRANSFORM, 0.0, theta0, psi0);
            this.inertToAligned = alignedToSorted0.applyInverseTo(this.sortedToBody.applyInverseTo(TorqueFree.this.initialAttitude.getRotation()));
            this.tScale = FastMath.copySign((double)FastMath.sqrt((double)(i32 * (m2 - twoE * i1C) / (i1C * i2C * i3C))), (double)(clockwise ? -omega0Sorted.getZ() : omega0Sorted.getZ()));
            this.o1Scale = FastMath.sqrt((double)((twoE * i3C - m2) / (i1C * i31)));
            this.o2Scale = FastMath.sqrt((double)((twoE * i3C - m2) / (i2C * i32)));
            this.o3Scale = FastMath.copySign((double)FastMath.sqrt((double)((m2 - twoE * i1C) / (i3C * i31))), (double)omega0Sorted.getZ());
            double k2 = twoE == 0.0 ? 0.0 : i21 * (twoE * i3C - m2) / (i32 * (m2 - twoE * i1C));
            this.jacobi = JacobiEllipticBuilder.build((double)k2);
            this.period = 4.0 * LegendreEllipticIntegral.bigK((double)k2) / this.tScale;
            double dtRef = this.o1Scale == 0.0 ? 0.0 : (FastMath.abs((double)omega0Sorted.getX()) >= FastMath.abs((double)omega0Sorted.getY()) ? (omega0Sorted.getX() >= 0.0 ? -this.jacobi.arcsn(omega0Sorted.getY() / this.o2Scale) / this.tScale : this.jacobi.arcsn(omega0Sorted.getY() / this.o2Scale) / this.tScale - 0.5 * this.period) : (omega0Sorted.getY() >= 0.0 ? -this.jacobi.arccn(omega0Sorted.getX() / this.o1Scale) / this.tScale : this.jacobi.arccn(omega0Sorted.getX() / this.o1Scale) / this.tScale));
            this.tRef = TorqueFree.this.initialAttitude.getDate().shiftedBy(dtRef);
            this.phiSlope = FastMath.sqrt((double)m2) / i3C;
            this.phiQuadratureModel = this.computePhiQuadratureModel(dtRef);
            this.integOnePeriod = this.phiQuadratureModel.getInterpolatedState(this.phiQuadratureModel.getFinalTime()).getPrimaryState()[0];
        }

        private DenseOutputModel computePhiQuadratureModel(final double dtRef) {
            double i1C = this.sortedInertia.getInertiaAxis1().getI();
            double i2C = this.sortedInertia.getInertiaAxis2().getI();
            double i3C = this.sortedInertia.getInertiaAxis3().getI();
            double i32 = i3C - i2C;
            double i31 = i3C - i1C;
            double i21 = i2C - i1C;
            final double b = this.phiSlope * i32 * i31;
            final double c = i1C * i32;
            final double d = i3C * i21;
            DormandPrince853Integrator integ = new DormandPrince853Integrator(1.0E-6 * this.period, 0.01 * this.period, this.phiSlope * this.period * 1.0E-13, 1.0E-13);
            DenseOutputModel model = new DenseOutputModel();
            integ.addStepHandler((ODEStepHandler)model);
            integ.integrate(new OrdinaryDifferentialEquation(){

                public int getDimension() {
                    return 1;
                }

                public double[] computeDerivatives(double t, double[] y) {
                    double sn = DoubleModel.this.jacobi.valuesN((t - dtRef) * DoubleModel.this.tScale).sn();
                    return new double[]{b / (c + d * sn * sn)};
                }
            }, new ODEState(0.0, new double[1]), this.period);
            return model;
        }

        public TimeStampedAngularCoordinates evaluate(AbsoluteDate date) {
            CopolarN valuesN = this.jacobi.valuesN(date.durationFrom(this.tRef) * this.tScale);
            Vector3D omegaSorted = new Vector3D(this.o1Scale * valuesN.cn(), this.o2Scale * valuesN.sn(), this.o3Scale * valuesN.dn());
            Vector3D omegaBody = this.sortedToBody.applyTo(omegaSorted);
            Vector3D accelerationSorted = new Vector3D(this.o1Scale * this.tScale * valuesN.cn() * valuesN.dn(), this.o2Scale * this.tScale * -valuesN.sn() * valuesN.dn(), this.o3Scale * this.tScale * -this.jacobi.getM() * valuesN.sn() * valuesN.cn());
            Vector3D accelerationBody = this.sortedToBody.applyTo(accelerationSorted);
            double dt = date.durationFrom(TorqueFree.this.initialAttitude.getDate());
            double psi = FastMath.atan2((double)(this.sortedInertia.getInertiaAxis1().getI() * omegaSorted.getX()), (double)(this.sortedInertia.getInertiaAxis2().getI() * omegaSorted.getY()));
            double theta = FastMath.acos((double)(omegaSorted.getZ() / this.phiSlope));
            double phiLinear = this.phiSlope * dt;
            int nbPeriods = (int)FastMath.floor((double)(dt / this.period));
            double tStartInteg = (double)nbPeriods * this.period;
            double integPartial = this.phiQuadratureModel.getInterpolatedState(dt - tStartInteg).getPrimaryState()[0];
            double phiQuadrature = (double)nbPeriods * this.integOnePeriod + integPartial;
            double phi = phiLinear + phiQuadrature;
            Rotation alignedToSorted = new Rotation(RotationOrder.ZXZ, RotationConvention.FRAME_TRANSFORM, phi, theta, psi);
            Rotation inertToBody = this.sortedToBody.applyTo(alignedToSorted.applyTo(this.inertToAligned));
            return new TimeStampedAngularCoordinates(date, inertToBody, omegaBody, accelerationBody);
        }
    }
}

