/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative2;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2Field;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.frames.Frame;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeShiftable;
import org.orekit.utils.ExtendedPositionProvider;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public interface TargetProvider {
    default public FieldVector3D<UnivariateDerivative2> getDerivative2TargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedPVCoordinates pv, Frame frame) {
        FieldPVCoordinates<UnivariateDerivative2> ud2PV = pv.toUnivariateDerivative2PV();
        UnivariateDerivative2Field field = UnivariateDerivative2Field.getInstance();
        UnivariateDerivative2 dt = new UnivariateDerivative2(0.0, 1.0, 0.0);
        FieldTimeShiftable ud2Date = new FieldAbsoluteDate(field, pv.getDate()).shiftedBy((CalculusFieldElement)dt);
        return this.getTargetDirection(sun, earth, new TimeStampedFieldPVCoordinates<UnivariateDerivative2>((FieldAbsoluteDate<UnivariateDerivative2>)ud2Date, ud2PV), frame);
    }

    default public Vector3D getTargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedPVCoordinates pv, Frame frame) {
        return this.getDerivative2TargetDirection(sun, earth, pv, frame).toVector3D();
    }

    default public <T extends CalculusFieldElement<T>> FieldVector3D<FieldUnivariateDerivative2<T>> getDerivative2TargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedFieldPVCoordinates<T> pv, Frame frame) {
        FieldPVCoordinates ud2PV = pv.toUnivariateDerivative2PV();
        FieldAbsoluteDate<FieldUnivariateDerivative2<T>> ud2Date = pv.getDate().toFUD2Field();
        return this.getTargetDirection(sun, earth, new TimeStampedFieldPVCoordinates(ud2Date, ud2PV), frame);
    }

    public <T extends CalculusFieldElement<T>> FieldVector3D<T> getTargetDirection(ExtendedPositionProvider var1, OneAxisEllipsoid var2, TimeStampedFieldPVCoordinates<T> var3, Frame var4);
}

