/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.GroundPointing;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.frames.FieldStaticTransform;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.StaticTransform;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class TargetPointing
extends GroundPointing {
    private final Vector3D target;

    public TargetPointing(Frame inertialFrame, Frame bodyFrame, Vector3D target) {
        super(inertialFrame, bodyFrame);
        this.target = target;
    }

    public TargetPointing(Frame inertialFrame, GeodeticPoint targetGeo, BodyShape shape) {
        super(inertialFrame, shape.getBodyFrame());
        this.target = shape.transform(targetGeo);
    }

    @Override
    public TimeStampedPVCoordinates getTargetPV(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        Transform t = this.getBodyFrame().getTransformTo(frame, date);
        TimeStampedPVCoordinates pv = new TimeStampedPVCoordinates(date, this.target, Vector3D.ZERO, Vector3D.ZERO);
        return t.transformPVCoordinates(pv);
    }

    @Override
    protected Vector3D getTargetPosition(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        StaticTransform staticTransform = this.getBodyFrame().getStaticTransformTo(frame, date);
        return staticTransform.transformPosition(this.target);
    }

    @Override
    public <T extends CalculusFieldElement<T>> TimeStampedFieldPVCoordinates<T> getTargetPV(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        FieldTransform<T> t = this.getBodyFrame().getTransformTo(frame, date);
        FieldVector3D zero = FieldVector3D.getZero(date.getField());
        TimeStampedFieldPVCoordinates<T> pv = new TimeStampedFieldPVCoordinates<T>(date, new FieldVector3D(date.getField(), this.target), zero, zero);
        return t.transformPVCoordinates(pv);
    }

    @Override
    protected <T extends CalculusFieldElement<T>> FieldVector3D<T> getTargetPosition(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        FieldStaticTransform<T> staticTransform = this.getBodyFrame().getStaticTransformTo(frame, date);
        return staticTransform.transformPosition(this.target);
    }
}

