/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import java.util.List;
import java.util.stream.Collectors;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.exception.Localizable;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.BoundedAttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.LOF;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.FieldAngularCoordinates;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.ImmutableTimeStampedCache;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedAngularCoordinatesHermiteInterpolator;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinatesHermiteInterpolator;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class TabulatedLofOffset
implements BoundedAttitudeProvider {
    private final Frame inertialFrame;
    private final LOF type;
    private final transient ImmutableTimeStampedCache<? extends TimeStampedAngularCoordinates> table;
    private final AngularDerivativesFilter filter;
    private final AbsoluteDate minDate;
    private final AbsoluteDate maxDate;

    public TabulatedLofOffset(Frame inertialFrame, LOF lof, List<? extends TimeStampedAngularCoordinates> table, int n, AngularDerivativesFilter filter) {
        this(inertialFrame, lof, table, n, filter, table.get(0).getDate(), table.get(table.size() - 1).getDate());
    }

    public TabulatedLofOffset(Frame inertialFrame, LOF lof, List<? extends TimeStampedAngularCoordinates> table, int n, AngularDerivativesFilter filter, AbsoluteDate minDate, AbsoluteDate maxDate) {
        if (!inertialFrame.isPseudoInertial()) {
            throw new OrekitException((Localizable)OrekitMessages.NON_PSEUDO_INERTIAL_FRAME, inertialFrame.getName());
        }
        this.inertialFrame = inertialFrame;
        this.type = lof;
        this.table = new ImmutableTimeStampedCache<TimeStampedAngularCoordinates>(n, table);
        this.filter = filter;
        this.minDate = minDate;
        this.maxDate = maxDate;
    }

    public List<? extends TimeStampedAngularCoordinates> getTable() {
        return this.table.getAll();
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        List sample = this.table.getNeighbors(date).collect(Collectors.toList());
        TimeStampedAngularCoordinatesHermiteInterpolator interpolator = new TimeStampedAngularCoordinatesHermiteInterpolator(sample.size(), this.filter);
        TimeStampedAngularCoordinates interpolated = (TimeStampedAngularCoordinates)interpolator.interpolate(date, sample);
        TimeStampedPVCoordinates pv = pvProv.getPVCoordinates(date, this.inertialFrame);
        Transform inertialToLof = this.type.transformFromInertial(date, pv);
        Transform frameToInertial = frame.getTransformTo(this.inertialFrame, date);
        Transform frameToLof = new Transform(date, frameToInertial, inertialToLof);
        return new Attitude(date, frame, interpolated.addOffset(frameToLof.getAngular()));
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        List sample = this.table.getNeighbors(date.toAbsoluteDate()).map(ac -> new TimeStampedFieldAngularCoordinates(date.getField(), (TimeStampedAngularCoordinates)ac)).collect(Collectors.toList());
        TimeStampedFieldAngularCoordinatesHermiteInterpolator<T> interpolator = new TimeStampedFieldAngularCoordinatesHermiteInterpolator<T>(sample.size(), this.filter);
        TimeStampedFieldAngularCoordinates interpolated = (TimeStampedFieldAngularCoordinates)interpolator.interpolate(date, sample);
        TimeStampedFieldPVCoordinates<T> pv = pvProv.getPVCoordinates(date, this.inertialFrame);
        FieldTransform<T> inertialToLof = this.type.transformFromInertial(date, pv);
        FieldTransform<T> frameToInertial = frame.getTransformTo(this.inertialFrame, date);
        FieldTransform<T> frameToLof = new FieldTransform<T>(date, frameToInertial, inertialToLof);
        return new FieldAttitude<T>(date, frame, interpolated.addOffset((FieldAngularCoordinates)frameToLof.getAngular()));
    }

    @Override
    public AbsoluteDate getMinDate() {
        return this.minDate;
    }

    @Override
    public AbsoluteDate getMaxDate() {
        return this.maxDate;
    }
}

