/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative2;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2Field;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.TargetProvider;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.frames.FieldStaticTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.StaticTransform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeShiftable;
import org.orekit.utils.ExtendedPositionProvider;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public enum PredefinedTarget implements TargetProvider
{
    SUN{

        @Override
        public FieldVector3D<UnivariateDerivative2> getDerivative2TargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedPVCoordinates pv, Frame frame) {
            return new PVCoordinates(pv, (PVCoordinates)sun.getPVCoordinates(pv.getDate(), frame)).toUnivariateDerivative2Vector().normalize();
        }

        @Override
        public Vector3D getTargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedPVCoordinates pv, Frame frame) {
            return (Vector3D)sun.getPosition(pv.getDate(), frame).subtract((Vector)pv.getPosition()).normalize();
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldVector3D<T> getTargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedFieldPVCoordinates<T> pv, Frame frame) {
            return sun.getPosition(pv.getDate(), frame).subtract(pv.getPosition()).normalize();
        }
    }
    ,
    EARTH{

        @Override
        public FieldVector3D<UnivariateDerivative2> getDerivative2TargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedPVCoordinates pv, Frame frame) {
            return pv.toUnivariateDerivative2Vector().negate().normalize();
        }

        @Override
        public Vector3D getTargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedPVCoordinates pv, Frame frame) {
            return (Vector3D)pv.getPosition().negate().normalize();
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldVector3D<FieldUnivariateDerivative2<T>> getDerivative2TargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedFieldPVCoordinates<T> pv, Frame frame) {
            return pv.toUnivariateDerivative2Vector().negate().normalize();
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldVector3D<T> getTargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedFieldPVCoordinates<T> pv, Frame frame) {
            return pv.getPosition().negate().normalize();
        }
    }
    ,
    NADIR{

        @Override
        public FieldVector3D<UnivariateDerivative2> getDerivative2TargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedPVCoordinates pv, Frame frame) {
            FieldStaticTransform inert2Earth = PredefinedTarget.inert2Earth(earth, pv.getDate(), frame);
            FieldGeodeticPoint gp = PredefinedTarget.toGeodeticPoint(earth, pv, inert2Earth);
            return inert2Earth.getStaticInverse().transformVector(gp.getNadir());
        }

        @Override
        public Vector3D getTargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedPVCoordinates pv, Frame frame) {
            StaticTransform inert2Earth = frame.getStaticTransformTo(earth.getBodyFrame(), pv.getDate());
            GeodeticPoint geodeticPoint = earth.transform(inert2Earth.transformPosition(pv.getPosition()), earth.getBodyFrame(), pv.getDate());
            return inert2Earth.getStaticInverse().transformVector(geodeticPoint.getNadir());
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldVector3D<T> getTargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedFieldPVCoordinates<T> pv, Frame frame) {
            FieldStaticTransform inert2Earth = frame.getStaticTransformTo(earth.getBodyFrame(), pv.getDate());
            FieldGeodeticPoint<T> geodeticPoint = earth.transform(inert2Earth.transformPosition(pv.getPosition()), earth.getBodyFrame(), pv.getDate());
            return inert2Earth.getStaticInverse().transformVector(geodeticPoint.getNadir());
        }
    }
    ,
    NORTH{

        @Override
        public FieldVector3D<UnivariateDerivative2> getDerivative2TargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedPVCoordinates pv, Frame frame) {
            FieldStaticTransform inert2Earth = PredefinedTarget.inert2Earth(earth, pv.getDate(), frame);
            FieldGeodeticPoint gp = PredefinedTarget.toGeodeticPoint(earth, pv, inert2Earth);
            return inert2Earth.getStaticInverse().transformVector(gp.getNorth());
        }

        @Override
        public Vector3D getTargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedPVCoordinates pv, Frame frame) {
            StaticTransform inert2Earth = frame.getStaticTransformTo(earth.getBodyFrame(), pv.getDate());
            GeodeticPoint geodeticPoint = earth.transform(inert2Earth.transformPosition(pv.getPosition()), earth.getBodyFrame(), pv.getDate());
            return inert2Earth.getStaticInverse().transformVector(geodeticPoint.getNorth());
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldVector3D<T> getTargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedFieldPVCoordinates<T> pv, Frame frame) {
            FieldStaticTransform inert2Earth = frame.getStaticTransformTo(earth.getBodyFrame(), pv.getDate());
            FieldGeodeticPoint<T> geodeticPoint = earth.transform(inert2Earth.transformPosition(pv.getPosition()), earth.getBodyFrame(), pv.getDate());
            return inert2Earth.getStaticInverse().transformVector(geodeticPoint.getNorth());
        }
    }
    ,
    EAST{

        @Override
        public FieldVector3D<UnivariateDerivative2> getDerivative2TargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedPVCoordinates pv, Frame frame) {
            FieldStaticTransform inert2Earth = PredefinedTarget.inert2Earth(earth, pv.getDate(), frame);
            FieldGeodeticPoint gp = PredefinedTarget.toGeodeticPoint(earth, pv, inert2Earth);
            return inert2Earth.getStaticInverse().transformVector(gp.getEast());
        }

        @Override
        public Vector3D getTargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedPVCoordinates pv, Frame frame) {
            StaticTransform inert2Earth = frame.getStaticTransformTo(earth.getBodyFrame(), pv.getDate());
            GeodeticPoint geodeticPoint = earth.transform(inert2Earth.transformPosition(pv.getPosition()), earth.getBodyFrame(), pv.getDate());
            return inert2Earth.getStaticInverse().transformVector(geodeticPoint.getEast());
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldVector3D<T> getTargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedFieldPVCoordinates<T> pv, Frame frame) {
            FieldStaticTransform inert2Earth = frame.getStaticTransformTo(earth.getBodyFrame(), pv.getDate());
            FieldGeodeticPoint<T> geodeticPoint = earth.transform(inert2Earth.transformPosition(pv.getPosition()), earth.getBodyFrame(), pv.getDate());
            return inert2Earth.getStaticInverse().transformVector(geodeticPoint.getEast());
        }
    }
    ,
    VELOCITY{

        @Override
        public FieldVector3D<UnivariateDerivative2> getDerivative2TargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedPVCoordinates pv, Frame frame) {
            return pv.toUnivariateDerivative2PV().getVelocity().normalize();
        }

        @Override
        public Vector3D getTargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedPVCoordinates pv, Frame frame) {
            return (Vector3D)pv.getVelocity().normalize();
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldVector3D<FieldUnivariateDerivative2<T>> getDerivative2TargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedFieldPVCoordinates<T> pv, Frame frame) {
            return pv.toUnivariateDerivative2PV().getVelocity().normalize();
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldVector3D<T> getTargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedFieldPVCoordinates<T> pv, Frame frame) {
            return pv.getVelocity().normalize();
        }
    }
    ,
    MOMENTUM{

        @Override
        public FieldVector3D<UnivariateDerivative2> getDerivative2TargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedPVCoordinates pv, Frame frame) {
            return pv.toUnivariateDerivative2PV().getMomentum().normalize();
        }

        @Override
        public Vector3D getTargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedPVCoordinates pv, Frame frame) {
            return (Vector3D)pv.getMomentum().normalize();
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldVector3D<FieldUnivariateDerivative2<T>> getDerivative2TargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedFieldPVCoordinates<T> pv, Frame frame) {
            return pv.toUnivariateDerivative2PV().getMomentum().normalize();
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldVector3D<T> getTargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedFieldPVCoordinates<T> pv, Frame frame) {
            return pv.getMomentum().normalize();
        }
    };


    private static FieldStaticTransform<UnivariateDerivative2> inert2Earth(OneAxisEllipsoid earth, AbsoluteDate date, Frame frame) {
        FieldTimeShiftable dateU2 = new FieldAbsoluteDate(UnivariateDerivative2Field.getInstance(), date).shiftedBy((CalculusFieldElement)new UnivariateDerivative2(0.0, 1.0, 0.0));
        return frame.getStaticTransformTo(earth.getBodyFrame(), dateU2);
    }

    private static FieldGeodeticPoint<UnivariateDerivative2> toGeodeticPoint(OneAxisEllipsoid earth, TimeStampedPVCoordinates pv, FieldStaticTransform<UnivariateDerivative2> inert2Earth) {
        return earth.transform(inert2Earth.transformPosition(pv.toUnivariateDerivative2Vector()), earth.getBodyFrame(), inert2Earth.getFieldDate());
    }
}

