/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import java.util.ArrayList;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative2;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative2Field;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2Field;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.GroundPointing;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.frames.FieldStaticTransform;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.StaticTransform;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeShiftable;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinatesHermiteInterpolator;
import org.orekit.utils.TimeStampedPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinatesHermiteInterpolator;

public class NadirPointing
extends GroundPointing {
    private final BodyShape shape;

    public NadirPointing(Frame inertialFrame, BodyShape shape) {
        super(inertialFrame, shape.getBodyFrame());
        this.shape = shape;
    }

    @Override
    public TimeStampedPVCoordinates getTargetPV(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        TimeStampedPVCoordinates pvCoordinatesInRef = pvProv.getPVCoordinates(date, frame);
        if (pvCoordinatesInRef.getAcceleration().equals((Object)Vector3D.ZERO)) {
            return this.getTargetPVViaInterpolation(pvProv, date, frame);
        }
        UnivariateDerivative2Field ud2Field = UnivariateDerivative2Field.getInstance();
        UnivariateDerivative2 dt = new UnivariateDerivative2(0.0, 1.0, 0.0);
        FieldTimeShiftable ud2Date = new FieldAbsoluteDate(ud2Field, date).shiftedBy((CalculusFieldElement)dt);
        FieldStaticTransform<UnivariateDerivative2> refToBody = frame.getStaticTransformTo(this.shape.getBodyFrame(), ud2Date);
        FieldVector3D<UnivariateDerivative2> positionInRefFrame = pvCoordinatesInRef.toUnivariateDerivative2Vector();
        FieldVector3D<UnivariateDerivative2> positionInBodyFrame = refToBody.transformPosition(positionInRefFrame);
        FieldGeodeticPoint<UnivariateDerivative2> gpSat = this.shape.transform(positionInBodyFrame, this.getBodyFrame(), ud2Date);
        FieldGeodeticPoint<UnivariateDerivative2> gpNadir = new FieldGeodeticPoint<UnivariateDerivative2>(gpSat.getLatitude(), gpSat.getLongitude(), ud2Field.getZero());
        FieldVector3D<UnivariateDerivative2> positionNadirInBodyFrame = this.shape.transform(gpNadir);
        FieldStaticTransform<UnivariateDerivative2> bodyToRef = refToBody.getInverse();
        FieldVector3D<UnivariateDerivative2> positionNadirInRefFrame = bodyToRef.transformPosition(positionNadirInBodyFrame);
        Vector3D velocity = new Vector3D(((UnivariateDerivative2)positionNadirInRefFrame.getX()).getFirstDerivative(), ((UnivariateDerivative2)positionNadirInRefFrame.getY()).getFirstDerivative(), ((UnivariateDerivative2)positionNadirInRefFrame.getZ()).getFirstDerivative());
        Vector3D acceleration = new Vector3D(((UnivariateDerivative2)positionNadirInRefFrame.getX()).getSecondDerivative(), ((UnivariateDerivative2)positionNadirInRefFrame.getY()).getSecondDerivative(), ((UnivariateDerivative2)positionNadirInRefFrame.getZ()).getSecondDerivative());
        return new TimeStampedPVCoordinates(date, positionNadirInRefFrame.toVector3D(), velocity, acceleration);
    }

    public TimeStampedPVCoordinates getTargetPVViaInterpolation(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        Transform refToBody = frame.getTransformTo(this.shape.getBodyFrame(), date);
        double h = 0.01;
        ArrayList<TimeStampedPVCoordinates> sample = new ArrayList<TimeStampedPVCoordinates>();
        sample.add(this.nadirRef(pvProv.getPVCoordinates(date.shiftedBy(-0.02), frame), refToBody.staticShiftedBy(-0.02)));
        sample.add(this.nadirRef(pvProv.getPVCoordinates(date.shiftedBy(-0.01), frame), refToBody.staticShiftedBy(-0.01)));
        sample.add(this.nadirRef(pvProv.getPVCoordinates(date, frame), refToBody));
        sample.add(this.nadirRef(pvProv.getPVCoordinates(date.shiftedBy(0.01), frame), refToBody.staticShiftedBy(0.01)));
        sample.add(this.nadirRef(pvProv.getPVCoordinates(date.shiftedBy(0.02), frame), refToBody.staticShiftedBy(0.02)));
        TimeStampedPVCoordinatesHermiteInterpolator interpolator = new TimeStampedPVCoordinatesHermiteInterpolator(sample.size(), CartesianDerivativesFilter.USE_P);
        return (TimeStampedPVCoordinates)interpolator.interpolate(date, sample);
    }

    @Override
    protected Vector3D getTargetPosition(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        Vector3D position = pvProv.getPosition(date, frame);
        PVCoordinates pVWithoutDerivatives = new PVCoordinates(position);
        StaticTransform refToBody = frame.getStaticTransformTo(this.shape.getBodyFrame(), date);
        return this.nadirRef(new TimeStampedPVCoordinates(date, pVWithoutDerivatives), refToBody).getPosition();
    }

    @Override
    public <T extends CalculusFieldElement<T>> TimeStampedFieldPVCoordinates<T> getTargetPV(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        TimeStampedFieldPVCoordinates<T> pvCoordinatesInRef = pvProv.getPVCoordinates(date, frame);
        Field<T> field = date.getField();
        if (pvCoordinatesInRef.getAcceleration().equals((Object)FieldVector3D.getZero(field))) {
            return this.getTargetPVViaInterpolation(pvProv, date, frame);
        }
        FieldUnivariateDerivative2Field ud2Field = FieldUnivariateDerivative2Field.getUnivariateDerivative2Field(field);
        FieldAbsoluteDate<FieldUnivariateDerivative2<T>> ud2Date = date.toFUD2Field();
        FieldStaticTransform refToBody = frame.getStaticTransformTo(this.shape.getBodyFrame(), ud2Date);
        FieldVector3D positionInRefFrame = pvCoordinatesInRef.toUnivariateDerivative2Vector();
        FieldVector3D positionInBodyFrame = refToBody.transformPosition(positionInRefFrame);
        FieldGeodeticPoint<FieldUnivariateDerivative2<T>> gpSat = this.shape.transform(positionInBodyFrame, this.getBodyFrame(), ud2Date);
        FieldGeodeticPoint<FieldUnivariateDerivative2> gpNadir = new FieldGeodeticPoint<FieldUnivariateDerivative2>(gpSat.getLatitude(), gpSat.getLongitude(), ud2Field.getZero());
        FieldVector3D<FieldUnivariateDerivative2> positionNadirInBodyFrame = this.shape.transform(gpNadir);
        FieldStaticTransform<FieldUnivariateDerivative2<FieldUnivariateDerivative2>> bodyToRef = refToBody.getInverse();
        FieldVector3D<FieldUnivariateDerivative2> positionNadirInRefFrame = bodyToRef.transformPosition(positionNadirInBodyFrame);
        FieldVector3D position = new FieldVector3D(((FieldUnivariateDerivative2)positionNadirInRefFrame.getX()).getValue(), ((FieldUnivariateDerivative2)positionNadirInRefFrame.getY()).getValue(), ((FieldUnivariateDerivative2)positionNadirInRefFrame.getZ()).getValue());
        FieldVector3D velocity = new FieldVector3D(((FieldUnivariateDerivative2)positionNadirInRefFrame.getX()).getFirstDerivative(), ((FieldUnivariateDerivative2)positionNadirInRefFrame.getY()).getFirstDerivative(), ((FieldUnivariateDerivative2)positionNadirInRefFrame.getZ()).getFirstDerivative());
        FieldVector3D acceleration = new FieldVector3D(((FieldUnivariateDerivative2)positionNadirInRefFrame.getX()).getSecondDerivative(), ((FieldUnivariateDerivative2)positionNadirInRefFrame.getY()).getSecondDerivative(), ((FieldUnivariateDerivative2)positionNadirInRefFrame.getZ()).getSecondDerivative());
        return new TimeStampedFieldPVCoordinates<T>(date, position, velocity, acceleration);
    }

    public <T extends CalculusFieldElement<T>> TimeStampedFieldPVCoordinates<T> getTargetPVViaInterpolation(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        CalculusFieldElement zero = (CalculusFieldElement)date.getField().getZero();
        FieldTransform<CalculusFieldElement> refToBody = frame.getTransformTo(this.shape.getBodyFrame(), date);
        double h = 0.01;
        ArrayList<TimeStampedFieldPVCoordinates<T>> sample = new ArrayList<TimeStampedFieldPVCoordinates<T>>();
        sample.add(this.nadirRef(pvProv.getPVCoordinates((FieldAbsoluteDate<T>)date.shiftedBy(-0.02), frame), refToBody.staticShiftedBy((CalculusFieldElement)zero.newInstance(-0.02))));
        sample.add(this.nadirRef(pvProv.getPVCoordinates((FieldAbsoluteDate<T>)date.shiftedBy(-0.01), frame), refToBody.staticShiftedBy((CalculusFieldElement)zero.newInstance(-0.01))));
        sample.add(this.nadirRef(pvProv.getPVCoordinates(date, frame), refToBody));
        sample.add(this.nadirRef(pvProv.getPVCoordinates((FieldAbsoluteDate<T>)date.shiftedBy(0.01), frame), refToBody.staticShiftedBy((CalculusFieldElement)zero.newInstance(0.01))));
        sample.add(this.nadirRef(pvProv.getPVCoordinates((FieldAbsoluteDate<T>)date.shiftedBy(0.02), frame), refToBody.staticShiftedBy((CalculusFieldElement)zero.newInstance(0.02))));
        TimeStampedFieldPVCoordinatesHermiteInterpolator<T> interpolator = new TimeStampedFieldPVCoordinatesHermiteInterpolator<T>(sample.size(), CartesianDerivativesFilter.USE_P);
        return (TimeStampedFieldPVCoordinates)interpolator.interpolate(date, sample);
    }

    @Override
    protected <T extends CalculusFieldElement<T>> FieldVector3D<T> getTargetPosition(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        FieldVector3D<T> position = pvProv.getPosition(date, frame);
        FieldPVCoordinates<T> pVWithoutDerivatives = new FieldPVCoordinates<T>(position, FieldVector3D.getZero(date.getField()));
        FieldStaticTransform<T> refToBody = frame.getStaticTransformTo(this.shape.getBodyFrame(), date);
        return this.nadirRef(new TimeStampedFieldPVCoordinates<T>(date, pVWithoutDerivatives), refToBody).getPosition();
    }

    private TimeStampedPVCoordinates nadirRef(TimeStampedPVCoordinates scRef, StaticTransform refToBody) {
        Vector3D satInBodyFrame = refToBody.transformPosition(scRef.getPosition());
        GeodeticPoint gpSat = this.shape.transform(satInBodyFrame, this.getBodyFrame(), scRef.getDate());
        GeodeticPoint gpNadir = new GeodeticPoint(gpSat.getLatitude(), gpSat.getLongitude(), 0.0);
        Vector3D pNadirBody = this.shape.transform(gpNadir);
        Vector3D pNadirRef = refToBody.getInverse().transformPosition(pNadirBody);
        return new TimeStampedPVCoordinates(scRef.getDate(), pNadirRef, Vector3D.ZERO, Vector3D.ZERO);
    }

    private <T extends CalculusFieldElement<T>> TimeStampedFieldPVCoordinates<T> nadirRef(TimeStampedFieldPVCoordinates<T> scRef, FieldStaticTransform<T> refToBody) {
        FieldVector3D<T> satInBodyFrame = refToBody.transformPosition(scRef.getPosition());
        FieldGeodeticPoint<T> gpSat = this.shape.transform(satInBodyFrame, this.getBodyFrame(), scRef.getDate());
        FieldGeodeticPoint<CalculusFieldElement> gpNadir = new FieldGeodeticPoint<CalculusFieldElement>((CalculusFieldElement)gpSat.getLatitude(), (CalculusFieldElement)gpSat.getLongitude(), (CalculusFieldElement)gpSat.getAltitude().getField().getZero());
        FieldVector3D<CalculusFieldElement> pNadirBody = this.shape.transform(gpNadir);
        FieldVector3D<CalculusFieldElement> pNadirRef = refToBody.getInverse().transformPosition(pNadirBody);
        FieldVector3D zero = FieldVector3D.getZero((Field)gpSat.getAltitude().getField());
        return new TimeStampedFieldPVCoordinates<CalculusFieldElement>(scRef.getDate(), pNadirRef, zero, zero);
    }
}

