/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.LOF;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class LofOffset
implements AttitudeProvider {
    private final LOF lof;
    private final Rotation offset;
    private final Frame inertialFrame;

    public LofOffset(Frame inertialFrame, LOF lof) {
        this(inertialFrame, lof, RotationOrder.XYZ, 0.0, 0.0, 0.0);
    }

    public LofOffset(Frame inertialFrame, LOF lof, RotationOrder order, double alpha1, double alpha2, double alpha3) {
        this.lof = lof;
        this.offset = new Rotation(order, RotationConvention.VECTOR_OPERATOR, alpha1, alpha2, alpha3).revert();
        if (!inertialFrame.isPseudoInertial()) {
            throw new OrekitException((Localizable)OrekitMessages.NON_PSEUDO_INERTIAL_FRAME, inertialFrame.getName());
        }
        this.inertialFrame = inertialFrame;
    }

    public LOF getLof() {
        return this.lof;
    }

    public Rotation getOffset() {
        return this.offset;
    }

    public Frame getInertialFrame() {
        return this.inertialFrame;
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        TimeStampedPVCoordinates pv = pvProv.getPVCoordinates(date, this.inertialFrame);
        Transform inertialToLof = this.lof.transformFromInertial(date, pv);
        Transform frameToInertial = frame.getTransformTo(this.inertialFrame, date);
        Transform frameToLof = new Transform(date, frameToInertial, inertialToLof);
        return new Attitude(date, frame, this.offset.compose(frameToLof.getRotation(), RotationConvention.VECTOR_OPERATOR), this.offset.applyTo(frameToLof.getRotationRate()), this.offset.applyTo(frameToLof.getRotationAcceleration()));
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        TimeStampedFieldPVCoordinates<T> pv = pvProv.getPVCoordinates(date, this.inertialFrame);
        FieldTransform<T> inertialToLof = this.lof.transformFromInertial(date, pv);
        FieldTransform<T> frameToInertial = frame.getTransformTo(this.inertialFrame, date);
        FieldTransform<T> frameToLof = new FieldTransform<T>(date, frameToInertial, inertialToLof);
        return new FieldAttitude<T>(date, frame, frameToLof.getRotation().compose(this.offset, RotationConvention.FRAME_TRANSFORM), FieldRotation.applyTo((Rotation)this.offset, frameToLof.getRotationRate()), FieldRotation.applyTo((Rotation)this.offset, frameToLof.getRotationAcceleration()));
    }

    @Override
    public Rotation getAttitudeRotation(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        TimeStampedPVCoordinates pv = pvProv.getPVCoordinates(date, this.inertialFrame);
        Rotation inertialToLof = this.lof.rotationFromInertial(date, pv);
        RotationConvention rotationConvention = RotationConvention.FRAME_TRANSFORM;
        Rotation frameToInertial = frame.getStaticTransformTo(this.inertialFrame, date).getRotation();
        Rotation frameToLof = frameToInertial.compose(inertialToLof, rotationConvention);
        return frameToLof.compose(this.offset, rotationConvention);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldRotation<T> getAttitudeRotation(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        TimeStampedFieldPVCoordinates<T> pv = pvProv.getPVCoordinates(date, this.inertialFrame);
        Field<T> field = date.getField();
        FieldRotation<T> inertialToLof = this.lof.rotationFromInertial(field, date, pv);
        RotationConvention rotationConvention = RotationConvention.FRAME_TRANSFORM;
        FieldRotation<T> frameToInertial = frame.getStaticTransformTo(this.inertialFrame, date).getRotation();
        FieldRotation frameToLof = frameToInertial.compose(inertialToLof, rotationConvention);
        return frameToLof.compose(this.offset, rotationConvention);
    }
}

