/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.InertiaAxis;

public class Inertia {
    private final InertiaAxis iA1;
    private final InertiaAxis iA2;
    private final InertiaAxis iA3;

    public Inertia(InertiaAxis iA1, InertiaAxis iA2, InertiaAxis iA3) {
        this.iA1 = iA1;
        this.iA2 = iA2;
        this.iA3 = iA3;
    }

    public Inertia swap12() {
        return new Inertia(this.iA2, this.iA1, this.iA3.negate());
    }

    public Inertia swap13() {
        return new Inertia(this.iA3, this.iA2.negate(), this.iA1);
    }

    public Inertia swap23() {
        return new Inertia(this.iA1.negate(), this.iA3, this.iA2);
    }

    public InertiaAxis getInertiaAxis1() {
        return this.iA1;
    }

    public InertiaAxis getInertiaAxis2() {
        return this.iA2;
    }

    public InertiaAxis getInertiaAxis3() {
        return this.iA3;
    }

    public Vector3D momentum(Vector3D rotationRate) {
        Vector3D a1 = this.iA1.getA();
        Vector3D a2 = this.iA2.getA();
        Vector3D a3 = this.iA3.getA();
        return new Vector3D(this.iA1.getI() * Vector3D.dotProduct((Vector3D)rotationRate, (Vector3D)a1), a1, this.iA2.getI() * Vector3D.dotProduct((Vector3D)rotationRate, (Vector3D)a2), a2, this.iA3.getI() * Vector3D.dotProduct((Vector3D)rotationRate, (Vector3D)a3), a3);
    }
}

