/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProviderModifier;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.attitudes.GroundPointing;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public abstract class GroundPointingAttitudeModifier
extends GroundPointing
implements AttitudeProviderModifier {
    private final GroundPointing groundPointingLaw;

    protected GroundPointingAttitudeModifier(Frame inertialFrame, Frame bodyFrame, GroundPointing groundPointingLaw) {
        super(inertialFrame, bodyFrame);
        this.groundPointingLaw = groundPointingLaw;
    }

    @Override
    public GroundPointing getUnderlyingAttitudeProvider() {
        return this.groundPointingLaw;
    }

    public Attitude getBaseState(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        return this.getUnderlyingAttitudeProvider().getAttitude(pvProv, date, frame);
    }

    public <T extends CalculusFieldElement<T>> FieldAttitude<T> getBaseState(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        return this.getUnderlyingAttitudeProvider().getAttitude(pvProv, date, frame);
    }

    @Override
    public TimeStampedPVCoordinates getTargetPV(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        return this.groundPointingLaw.getTargetPV(pvProv, date, frame);
    }

    @Override
    protected Vector3D getTargetPosition(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        return this.groundPointingLaw.getTargetPosition(pvProv, date, frame);
    }

    @Override
    public <T extends CalculusFieldElement<T>> TimeStampedFieldPVCoordinates<T> getTargetPV(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        return this.groundPointingLaw.getTargetPV(pvProv, date, frame);
    }

    @Override
    protected <T extends CalculusFieldElement<T>> FieldVector3D<T> getTargetPosition(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        return this.groundPointingLaw.getTargetPosition(pvProv, date, frame);
    }
}

