/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import java.util.HashMap;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative2;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.TargetProvider;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.frames.FieldStaticTransform;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.StaticTransform;
import org.orekit.frames.Transform;
import org.orekit.utils.ExtendedPositionProvider;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class GroundPointTarget
implements TargetProvider {
    private final PVCoordinates location;
    private final transient Map<Field<? extends CalculusFieldElement<?>>, FieldPVCoordinates<?>> cachedLocations;

    public GroundPointTarget(Vector3D location) {
        this.location = new PVCoordinates(location, Vector3D.ZERO, Vector3D.ZERO);
        this.cachedLocations = new HashMap();
    }

    @Override
    public FieldVector3D<UnivariateDerivative2> getDerivative2TargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedPVCoordinates pv, Frame frame) {
        Transform earthToInert = earth.getFrame().getTransformTo(frame, pv.getDate());
        return new PVCoordinates(pv, earthToInert.transformPVCoordinates(this.location)).toUnivariateDerivative2Vector().normalize();
    }

    @Override
    public Vector3D getTargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedPVCoordinates pv, Frame frame) {
        StaticTransform earthToInert = earth.getFrame().getStaticTransformTo(frame, pv.getDate());
        return (Vector3D)earthToInert.transformPosition(this.location.getPosition()).subtract((Vector)pv.getPosition()).normalize();
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<FieldUnivariateDerivative2<T>> getDerivative2TargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedFieldPVCoordinates<T> pv, Frame frame) {
        Field field = pv.getDate().getField();
        FieldPVCoordinates l = this.cachedLocations.computeIfAbsent(field, f -> {
            CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
            return new FieldPVCoordinates(new FieldVector3D((CalculusFieldElement)zero.newInstance(this.location.getPosition().getX()), (CalculusFieldElement)zero.newInstance(this.location.getPosition().getY()), (CalculusFieldElement)zero.newInstance(this.location.getPosition().getZ())), FieldVector3D.getZero((Field)field), FieldVector3D.getZero((Field)field));
        });
        FieldTransform<T> earthToInert = earth.getFrame().getTransformTo(frame, pv.getDate());
        return new FieldPVCoordinates<T>(pv, earthToInert.transformPVCoordinates(l)).toUnivariateDerivative2Vector().normalize();
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> getTargetDirection(ExtendedPositionProvider sun, OneAxisEllipsoid earth, TimeStampedFieldPVCoordinates<T> pv, Frame frame) {
        FieldStaticTransform<T> earthToInert = earth.getFrame().getStaticTransformTo(frame, pv.getDate());
        return earthToInert.transformPosition(this.location.getPosition()).subtract(pv.getPosition()).normalize();
    }
}

