/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.frames.FieldStaticTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.StaticTransform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;

public class FixedRate
implements AttitudeProvider {
    private final Attitude referenceAttitude;

    public FixedRate(Attitude referenceAttitude) {
        this.referenceAttitude = referenceAttitude;
    }

    @Override
    public Rotation getAttitudeRotation(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        Rotation rotation = this.getShiftedAttitude(date).getRotation();
        StaticTransform transform = this.referenceAttitude.getReferenceFrame().getStaticTransformTo(frame, date);
        return rotation.compose(transform.getRotation(), RotationConvention.FRAME_TRANSFORM);
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        Attitude shifted = this.getShiftedAttitude(date);
        return shifted.withReferenceFrame(frame);
    }

    private Attitude getShiftedAttitude(AbsoluteDate date) {
        double timeShift = date.durationFrom(this.referenceAttitude.getDate());
        return this.referenceAttitude.shiftedBy(timeShift);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldRotation<T> getAttitudeRotation(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        FieldRotation<T> rotation = this.getShiftedAttitude(date).getRotation();
        FieldStaticTransform<T> transform = this.referenceAttitude.getReferenceFrame().getStaticTransformTo(frame, date);
        return rotation.compose(transform.getRotation(), RotationConvention.FRAME_TRANSFORM);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        FieldAttitude<T> shifted = this.getShiftedAttitude(date);
        return shifted.withReferenceFrame(frame);
    }

    private <T extends CalculusFieldElement<T>> FieldAttitude<T> getShiftedAttitude(FieldAbsoluteDate<T> date) {
        Field<T> field = date.getField();
        T timeShift = date.durationFrom(this.referenceAttitude.getDate());
        return new FieldAttitude<T>(field, this.referenceAttitude).shiftedBy((CalculusFieldElement)timeShift);
    }

    public Attitude getReferenceAttitude() {
        return this.referenceAttitude;
    }
}

