/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.attitudes.FieldInertiaAxis;

public class FieldInertia<T extends CalculusFieldElement<T>> {
    private final FieldInertiaAxis<T> iA1;
    private final FieldInertiaAxis<T> iA2;
    private final FieldInertiaAxis<T> iA3;

    FieldInertia(FieldInertiaAxis<T> iA1, FieldInertiaAxis<T> iA2, FieldInertiaAxis<T> iA3) {
        this.iA1 = iA1;
        this.iA2 = iA2;
        this.iA3 = iA3;
    }

    public FieldInertia<T> swap12() {
        return new FieldInertia<T>(this.iA2, this.iA1, this.iA3.negate());
    }

    public FieldInertia<T> swap13() {
        return new FieldInertia<T>(this.iA3, this.iA2.negate(), this.iA1);
    }

    public FieldInertia<T> swap23() {
        return new FieldInertia<T>(this.iA1.negate(), this.iA3, this.iA2);
    }

    public FieldInertiaAxis<T> getInertiaAxis1() {
        return this.iA1;
    }

    public FieldInertiaAxis<T> getInertiaAxis2() {
        return this.iA2;
    }

    public FieldInertiaAxis<T> getInertiaAxis3() {
        return this.iA3;
    }

    public FieldVector3D<T> momentum(FieldVector3D<T> rotationRate) {
        FieldVector3D<T> a1 = this.iA1.getA();
        FieldVector3D<T> a2 = this.iA2.getA();
        FieldVector3D<T> a3 = this.iA3.getA();
        return new FieldVector3D((CalculusFieldElement)this.iA1.getI().multiply((FieldElement)FieldVector3D.dotProduct(rotationRate, a1)), a1, (CalculusFieldElement)this.iA2.getI().multiply((FieldElement)FieldVector3D.dotProduct(rotationRate, a2)), a2, (CalculusFieldElement)this.iA3.getI().multiply((FieldElement)FieldVector3D.dotProduct(rotationRate, a3)), a3);
    }
}

