/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.frames.Frame;
import org.orekit.time.AbstractFieldTimeInterpolator;
import org.orekit.time.FieldTimeInterpolator;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class FieldAttitudeInterpolator<KK extends CalculusFieldElement<KK>>
extends AbstractFieldTimeInterpolator<FieldAttitude<KK>, KK> {
    private final Frame referenceFrame;
    private final FieldTimeInterpolator<TimeStampedFieldAngularCoordinates<KK>, KK> interpolator;

    public FieldAttitudeInterpolator(Frame referenceFrame, FieldTimeInterpolator<TimeStampedFieldAngularCoordinates<KK>, KK> interpolator) {
        super(interpolator.getNbInterpolationPoints(), interpolator.getExtrapolationThreshold());
        this.referenceFrame = referenceFrame;
        this.interpolator = interpolator;
    }

    public Frame getReferenceFrame() {
        return this.referenceFrame;
    }

    public FieldTimeInterpolator<TimeStampedFieldAngularCoordinates<KK>, KK> getAngularInterpolator() {
        return this.interpolator;
    }

    @Override
    protected FieldAttitude<KK> interpolate(AbstractFieldTimeInterpolator.InterpolationData interpolationData) {
        Stream sample = interpolationData.getNeighborList().stream();
        Stream<FieldAttitude> consistentSample = sample.map(attitude -> attitude.withReferenceFrame(this.referenceFrame));
        List angularSample = consistentSample.map(FieldAttitude::getOrientation).collect(Collectors.toList());
        TimeStampedFieldAngularCoordinates<KK> interpolated = this.interpolator.interpolate(interpolationData.getInterpolationDate(), angularSample);
        return new FieldAttitude<KK>(this.referenceFrame, interpolated);
    }
}

