/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeShiftable;
import org.orekit.time.FieldTimeStamped;
import org.orekit.utils.FieldAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class FieldAttitude<T extends CalculusFieldElement<T>>
implements FieldTimeStamped<T>,
FieldTimeShiftable<FieldAttitude<T>, T> {
    private final Frame referenceFrame;
    private final TimeStampedFieldAngularCoordinates<T> orientation;

    public FieldAttitude(Frame referenceFrame, TimeStampedFieldAngularCoordinates<T> orientation) {
        this.referenceFrame = referenceFrame;
        this.orientation = orientation;
    }

    public FieldAttitude(FieldAbsoluteDate<T> date, Frame referenceFrame, FieldAngularCoordinates<T> orientation) {
        this(referenceFrame, new TimeStampedFieldAngularCoordinates<T>(date, orientation.getRotation(), orientation.getRotationRate(), orientation.getRotationAcceleration()));
    }

    public FieldAttitude(FieldAbsoluteDate<T> date, Frame referenceFrame, FieldRotation<T> attitude, FieldVector3D<T> spin, FieldVector3D<T> acceleration) {
        this(referenceFrame, new TimeStampedFieldAngularCoordinates<T>(date, attitude, spin, acceleration));
    }

    public FieldAttitude(FieldAbsoluteDate<T> date, Frame referenceFrame, Rotation attitude, Vector3D spin, Vector3D acceleration, Field<T> field) {
        this(referenceFrame, new TimeStampedFieldAngularCoordinates<T>(date, new FieldRotation(field, attitude), new FieldVector3D(field, spin), new FieldVector3D(field, acceleration)));
    }

    public FieldAttitude(Field<T> field, Attitude attitude) {
        this(attitude.getReferenceFrame(), new TimeStampedFieldAngularCoordinates<T>(field, attitude.getOrientation()));
    }

    @Override
    public FieldAttitude<T> shiftedBy(double dt) {
        return new FieldAttitude<T>(this.referenceFrame, this.orientation.shiftedBy(dt));
    }

    @Override
    public FieldAttitude<T> shiftedBy(T dt) {
        return new FieldAttitude<T>(this.referenceFrame, this.orientation.shiftedBy((CalculusFieldElement)dt));
    }

    public FieldAttitude<T> withReferenceFrame(Frame newReferenceFrame) {
        if (newReferenceFrame == this.referenceFrame) {
            return this;
        }
        Transform t = newReferenceFrame.getTransformTo(this.referenceFrame, this.orientation.getDate().toAbsoluteDate());
        return new FieldAttitude<T>(this.orientation.getDate(), newReferenceFrame, this.orientation.getRotation().compose(t.getRotation(), RotationConvention.VECTOR_OPERATOR), this.orientation.getRotationRate().add(this.orientation.getRotation().applyTo(t.getRotationRate())), this.orientation.getRotationAcceleration().add(this.orientation.getRotation().applyTo(t.getRotationAcceleration())));
    }

    @Override
    public FieldAbsoluteDate<T> getDate() {
        return this.orientation.getDate();
    }

    public Frame getReferenceFrame() {
        return this.referenceFrame;
    }

    public TimeStampedFieldAngularCoordinates<T> getOrientation() {
        return this.orientation;
    }

    public FieldRotation<T> getRotation() {
        return this.orientation.getRotation();
    }

    public FieldVector3D<T> getSpin() {
        return this.orientation.getRotationRate();
    }

    public FieldVector3D<T> getRotationAcceleration() {
        return this.orientation.getRotationAcceleration();
    }

    public Attitude toAttitude() {
        return new Attitude(this.orientation.getDate().toAbsoluteDate(), this.referenceFrame, this.orientation.toAngularCoordinates());
    }
}

