/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.attitudes.GroundPointing;
import org.orekit.bodies.Ellipsoid;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class BodyCenterPointing
extends GroundPointing {
    private final Ellipsoid ellipsoid;

    public BodyCenterPointing(Frame inertialFrame, Ellipsoid shape) {
        super(inertialFrame, shape.getFrame());
        this.ellipsoid = shape;
    }

    @Override
    public TimeStampedPVCoordinates getTargetPV(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        TimeStampedPVCoordinates scInBodyFrame = pvProv.getPVCoordinates(date, this.getBodyFrame());
        double u = scInBodyFrame.getPosition().getX() / this.ellipsoid.getA();
        double v = scInBodyFrame.getPosition().getY() / this.ellipsoid.getB();
        double w = scInBodyFrame.getPosition().getZ() / this.ellipsoid.getC();
        double d2 = u * u + v * v + w * w;
        double d = FastMath.sqrt((double)d2);
        double ratio = 1.0 / d;
        Vector3D projectedP = new Vector3D(ratio, scInBodyFrame.getPosition());
        double uDot = scInBodyFrame.getVelocity().getX() / this.ellipsoid.getA();
        double vDot = scInBodyFrame.getVelocity().getY() / this.ellipsoid.getB();
        double wDot = scInBodyFrame.getVelocity().getZ() / this.ellipsoid.getC();
        double dDot = MathArrays.linearCombination((double)u, (double)uDot, (double)v, (double)vDot, (double)w, (double)wDot) / d;
        double ratioDot = -dDot / d2;
        Vector3D projectedV = new Vector3D(ratio, scInBodyFrame.getVelocity(), ratioDot, scInBodyFrame.getPosition());
        double uDotDot = scInBodyFrame.getAcceleration().getX() / this.ellipsoid.getA();
        double vDotDot = scInBodyFrame.getAcceleration().getY() / this.ellipsoid.getB();
        double wDotDot = scInBodyFrame.getAcceleration().getZ() / this.ellipsoid.getC();
        double dDotDot = (MathArrays.linearCombination((double)u, (double)uDotDot, (double)v, (double)vDotDot, (double)w, (double)wDotDot) + uDot * uDot + vDot * vDot + wDot * wDot - dDot * dDot) / d;
        double ratioDotDot = (2.0 * dDot * dDot - d * dDotDot) / (d * d2);
        Vector3D projectedA = new Vector3D(ratio, scInBodyFrame.getAcceleration(), 2.0 * ratioDot, scInBodyFrame.getVelocity(), ratioDotDot, scInBodyFrame.getPosition());
        TimeStampedPVCoordinates projected = new TimeStampedPVCoordinates(date, projectedP, projectedV, projectedA);
        return this.getBodyFrame().getTransformTo(frame, date).transformPVCoordinates(projected);
    }

    @Override
    protected Vector3D getTargetPosition(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        Vector3D scPositionInBodyFrame = pvProv.getPosition(date, this.getBodyFrame());
        double u = scPositionInBodyFrame.getX() / this.ellipsoid.getA();
        double v = scPositionInBodyFrame.getY() / this.ellipsoid.getB();
        double w = scPositionInBodyFrame.getZ() / this.ellipsoid.getC();
        double d2 = u * u + v * v + w * w;
        double d = FastMath.sqrt((double)d2);
        double ratio = 1.0 / d;
        Vector3D projectedP = new Vector3D(ratio, scPositionInBodyFrame);
        return this.getBodyFrame().getStaticTransformTo(frame, date).transformPosition(projectedP);
    }

    @Override
    public <T extends CalculusFieldElement<T>> TimeStampedFieldPVCoordinates<T> getTargetPV(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        TimeStampedFieldPVCoordinates<T> scInBodyFrame = pvProv.getPVCoordinates(date, this.getBodyFrame());
        CalculusFieldElement u = (CalculusFieldElement)scInBodyFrame.getPosition().getX().divide(this.ellipsoid.getA());
        CalculusFieldElement v = (CalculusFieldElement)scInBodyFrame.getPosition().getY().divide(this.ellipsoid.getB());
        CalculusFieldElement w = (CalculusFieldElement)scInBodyFrame.getPosition().getZ().divide(this.ellipsoid.getC());
        CalculusFieldElement d2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u.pow(2)).add((FieldElement)((CalculusFieldElement)v.pow(2)))).add((FieldElement)((CalculusFieldElement)w.pow(2)));
        CalculusFieldElement d = (CalculusFieldElement)d2.sqrt();
        CalculusFieldElement ratio = (CalculusFieldElement)d.reciprocal();
        FieldVector3D projectedP = new FieldVector3D(ratio, scInBodyFrame.getPosition());
        CalculusFieldElement uDot = (CalculusFieldElement)scInBodyFrame.getVelocity().getX().divide(this.ellipsoid.getA());
        CalculusFieldElement vDot = (CalculusFieldElement)scInBodyFrame.getVelocity().getY().divide(this.ellipsoid.getB());
        CalculusFieldElement wDot = (CalculusFieldElement)scInBodyFrame.getVelocity().getZ().divide(this.ellipsoid.getC());
        CalculusFieldElement dDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u.multiply((FieldElement)uDot)).add((FieldElement)((CalculusFieldElement)v.multiply((FieldElement)vDot)))).add((FieldElement)((CalculusFieldElement)w.multiply((FieldElement)wDot)))).divide((FieldElement)d);
        CalculusFieldElement ratioDot = (CalculusFieldElement)((CalculusFieldElement)dDot.multiply(-1)).divide((FieldElement)d2);
        FieldVector3D projectedV = new FieldVector3D(ratio, scInBodyFrame.getVelocity(), ratioDot, scInBodyFrame.getPosition());
        CalculusFieldElement uDotDot = (CalculusFieldElement)scInBodyFrame.getAcceleration().getX().divide(this.ellipsoid.getA());
        CalculusFieldElement vDotDot = (CalculusFieldElement)scInBodyFrame.getAcceleration().getY().divide(this.ellipsoid.getB());
        CalculusFieldElement wDotDot = (CalculusFieldElement)scInBodyFrame.getAcceleration().getZ().divide(this.ellipsoid.getC());
        CalculusFieldElement dDotDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u.multiply((FieldElement)uDotDot)).add((FieldElement)((CalculusFieldElement)v.multiply((FieldElement)vDotDot)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)w.multiply((FieldElement)wDotDot)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)uDot.pow(2)).add((FieldElement)((CalculusFieldElement)vDot.pow(2)))).add((FieldElement)((CalculusFieldElement)wDot.pow(2)))).subtract((FieldElement)((CalculusFieldElement)dDot.pow(2)))))))).divide((FieldElement)d);
        CalculusFieldElement ratioDotDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dDot.pow(2)).multiply(2)).subtract((FieldElement)((CalculusFieldElement)d.multiply((FieldElement)dDotDot)))).divide((FieldElement)((CalculusFieldElement)d.multiply((FieldElement)d2)));
        FieldVector3D projectedA = new FieldVector3D(ratio, scInBodyFrame.getAcceleration(), (CalculusFieldElement)ratioDot.multiply(2), scInBodyFrame.getVelocity(), ratioDotDot, scInBodyFrame.getPosition());
        TimeStampedFieldPVCoordinates<T> projected = new TimeStampedFieldPVCoordinates<T>(date, projectedP, projectedV, projectedA);
        return this.getBodyFrame().getTransformTo(frame, date.toAbsoluteDate()).transformPVCoordinates(projected);
    }

    @Override
    protected <T extends CalculusFieldElement<T>> FieldVector3D<T> getTargetPosition(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        FieldVector3D<T> scPositionInBodyFrame = pvProv.getPosition(date, this.getBodyFrame());
        CalculusFieldElement u = (CalculusFieldElement)scPositionInBodyFrame.getX().divide(this.ellipsoid.getA());
        CalculusFieldElement v = (CalculusFieldElement)scPositionInBodyFrame.getY().divide(this.ellipsoid.getB());
        CalculusFieldElement w = (CalculusFieldElement)scPositionInBodyFrame.getZ().divide(this.ellipsoid.getC());
        CalculusFieldElement d = new FieldVector3D(u, v, w).getNorm();
        FieldVector3D projectedP = new FieldVector3D((CalculusFieldElement)d.reciprocal(), scPositionInBodyFrame);
        return this.getBodyFrame().getStaticTransformTo(frame, date).transformPosition(projectedP);
    }
}

