/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.ode.events.Action;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.FieldPropagator;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldAdaptableInterval;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.DoubleArrayDictionary;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedAngularCoordinatesHermiteInterpolator;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinatesHermiteInterpolator;

public class AttitudesSequence
implements AttitudeProvider {
    private transient TimeSpanMap<AttitudeProvider> activated = null;
    private final List<Switch> switches = new ArrayList<Switch>();

    public void resetActiveProvider(AttitudeProvider provider) {
        this.activated = new TimeSpanMap<AttitudeProvider>(provider);
    }

    public void registerSwitchEvents(Propagator propagator) {
        for (Switch s : this.switches) {
            propagator.addEventDetector(s);
        }
    }

    public <T extends CalculusFieldElement<T>> void registerSwitchEvents(final Field<T> field, FieldPropagator<T> propagator) {
        for (final Switch sw : this.switches) {
            propagator.addEventDetector(new FieldEventDetector<T>(){

                @Override
                public void init(FieldSpacecraftState<T> s0, FieldAbsoluteDate<T> t) {
                    sw.init(s0.toSpacecraftState(), t.toAbsoluteDate());
                }

                @Override
                public T g(FieldSpacecraftState<T> s) {
                    return (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(sw.g(s.toSpacecraftState()));
                }

                @Override
                public T getThreshold() {
                    return (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(sw.getThreshold());
                }

                @Override
                public FieldAdaptableInterval<T> getMaxCheckInterval() {
                    return s -> sw.getMaxCheckInterval().currentInterval(s.toSpacecraftState());
                }

                @Override
                public int getMaxIterationCount() {
                    return sw.getMaxIterationCount();
                }

                @Override
                public FieldEventHandler<T> getHandler() {
                    return new FieldEventHandler<T>(){

                        @Override
                        public Action eventOccurred(FieldSpacecraftState<T> s, FieldEventDetector<T> detector, boolean increasing) {
                            return sw.eventOccurred(s.toSpacecraftState(), sw, increasing);
                        }

                        @Override
                        public FieldSpacecraftState<T> resetState(FieldEventDetector<T> detector, FieldSpacecraftState<T> oldState) {
                            return new FieldSpacecraftState(field, sw.resetState(sw, oldState.toSpacecraftState()));
                        }
                    };
                }
            });
        }
    }

    public <T extends EventDetector> void addSwitchingCondition(AttitudeProvider past, AttitudeProvider future, T switchEvent, boolean switchOnIncrease, boolean switchOnDecrease, double transitionTime, AngularDerivativesFilter transitionFilter, SwitchHandler handler) {
        if (transitionTime < switchEvent.getThreshold()) {
            throw new OrekitException((Localizable)OrekitMessages.TOO_SHORT_TRANSITION_TIME_FOR_ATTITUDES_SWITCH, transitionTime, switchEvent.getThreshold());
        }
        if (this.activated == null) {
            this.resetActiveProvider(past);
        }
        this.switches.add(new Switch(switchEvent, switchOnIncrease, switchOnDecrease, past, future, transitionTime, transitionFilter, handler));
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        return this.activated.get(date).getAttitude(pvProv, date, frame);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        return this.activated.get(date.toAbsoluteDate()).getAttitude(pvProv, date, frame);
    }

    @Override
    public Rotation getAttitudeRotation(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        return this.activated.get(date).getAttitudeRotation(pvProv, date, frame);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldRotation<T> getAttitudeRotation(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        return this.activated.get(date.toAbsoluteDate()).getAttitudeRotation(pvProv, date, frame);
    }

    public List<Switch> getSwitches() {
        return new ArrayList<Switch>(this.switches);
    }

    public static interface SwitchHandler {
        public void switchOccurred(AttitudeProvider var1, AttitudeProvider var2, SpacecraftState var3);
    }

    public class Switch
    implements EventDetector,
    EventHandler {
        private final EventDetector event;
        private final boolean switchOnIncrease;
        private final boolean switchOnDecrease;
        private final AttitudeProvider past;
        private final AttitudeProvider future;
        private final double transitionTime;
        private final AngularDerivativesFilter transitionFilter;
        private final SwitchHandler switchHandler;
        private boolean forward;

        private Switch(EventDetector event, boolean switchOnIncrease, boolean switchOnDecrease, AttitudeProvider past, AttitudeProvider future, double transitionTime, AngularDerivativesFilter transitionFilter, SwitchHandler switchHandler) {
            this.event = event;
            this.switchOnIncrease = switchOnIncrease;
            this.switchOnDecrease = switchOnDecrease;
            this.past = past;
            this.future = future;
            this.transitionTime = transitionTime;
            this.transitionFilter = transitionFilter;
            this.switchHandler = switchHandler;
        }

        @Override
        public double getThreshold() {
            return this.event.getThreshold();
        }

        @Override
        public AdaptableInterval getMaxCheckInterval() {
            return this.event.getMaxCheckInterval();
        }

        @Override
        public int getMaxIterationCount() {
            return this.event.getMaxIterationCount();
        }

        @Override
        public void init(SpacecraftState s0, AbsoluteDate t) {
            boolean bl = this.forward = t.durationFrom(s0.getDate()) >= 0.0;
            if (AttitudesSequence.this.activated.getSpansNumber() > 1) {
                if (this.forward) {
                    AttitudesSequence.this.activated = AttitudesSequence.this.activated.extractRange(AbsoluteDate.PAST_INFINITY, s0.getDate().shiftedBy(this.transitionTime));
                } else {
                    AttitudesSequence.this.activated = AttitudesSequence.this.activated.extractRange(s0.getDate().shiftedBy(-this.transitionTime), AbsoluteDate.FUTURE_INFINITY);
                }
            }
            this.event.init(s0, t);
        }

        @Override
        public double g(SpacecraftState s) {
            return this.event.g(this.forward ? s : s.shiftedBy(-this.transitionTime));
        }

        @Override
        public EventHandler getHandler() {
            return this;
        }

        @Override
        public Action eventOccurred(SpacecraftState s, EventDetector detector, boolean increasing) {
            AbsoluteDate date = s.getDate();
            if (AttitudesSequence.this.activated.get(date) == (this.forward ? this.past : this.future) && (increasing && this.switchOnIncrease || !increasing && this.switchOnDecrease)) {
                if (this.forward) {
                    AbsoluteDate transitionEnd = date.shiftedBy(this.transitionTime);
                    AttitudesSequence.this.activated.addValidAfter(new TransitionProvider(s.getAttitude(), transitionEnd), date, false);
                    AttitudesSequence.this.activated.addValidAfter(this.future, transitionEnd, false);
                    if (this.switchHandler != null) {
                        this.switchHandler.switchOccurred(this.past, this.future, s);
                    }
                    return this.event.getHandler().eventOccurred(s, this.event, increasing);
                }
                Orbit sOrbit = s.getOrbit().shiftedBy(-this.transitionTime);
                Attitude sAttitude = this.past.getAttitude(sOrbit, sOrbit.getDate(), sOrbit.getFrame());
                SpacecraftState sState = new SpacecraftState(sOrbit, sAttitude, s.getMass());
                for (DoubleArrayDictionary.Entry entry : s.getAdditionalStatesValues().getData()) {
                    sState = sState.addAdditionalState(entry.getKey(), entry.getValue());
                }
                AttitudesSequence.this.activated.addValidBefore(new TransitionProvider(sAttitude, date), date, false);
                AttitudesSequence.this.activated.addValidBefore(this.past, sOrbit.getDate(), false);
                if (this.switchHandler != null) {
                    this.switchHandler.switchOccurred(this.future, this.past, sState);
                }
                return this.event.getHandler().eventOccurred(sState, this.event, increasing);
            }
            return this.event.getHandler().eventOccurred(s, this.event, increasing);
        }

        @Override
        public SpacecraftState resetState(EventDetector detector, SpacecraftState oldState) {
            return this.event.getHandler().resetState(this.event, oldState);
        }

        private class TransitionProvider
        implements AttitudeProvider {
            private final Attitude transitionPreceding;
            private final AbsoluteDate transitionEnd;

            TransitionProvider(Attitude transitionPreceding, AbsoluteDate transitionEnd) {
                this.transitionPreceding = transitionPreceding;
                this.transitionEnd = transitionEnd;
            }

            @Override
            public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
                TimeStampedAngularCoordinates start = this.transitionPreceding.withReferenceFrame(frame).getOrientation();
                TimeStampedAngularCoordinates end = Switch.this.future.getAttitude(pvProv, this.transitionEnd, frame).getOrientation();
                List<TimeStampedAngularCoordinates> sample = Arrays.asList(start, end);
                TimeStampedAngularCoordinatesHermiteInterpolator interpolator = new TimeStampedAngularCoordinatesHermiteInterpolator(sample.size(), Switch.this.transitionFilter);
                TimeStampedAngularCoordinates interpolated = interpolator.interpolate(date, sample);
                return new Attitude(frame, interpolated);
            }

            public <S extends CalculusFieldElement<S>> FieldAttitude<S> getAttitude(FieldPVCoordinatesProvider<S> pvProv, FieldAbsoluteDate<S> date, Frame frame) {
                TimeStampedFieldAngularCoordinates<S> start = new TimeStampedFieldAngularCoordinates<S>(date.getField(), this.transitionPreceding.withReferenceFrame(frame).getOrientation());
                TimeStampedFieldAngularCoordinates<S> end = Switch.this.future.getAttitude(pvProv, new FieldAbsoluteDate<S>(date.getField(), this.transitionEnd), frame).getOrientation();
                List<TimeStampedFieldAngularCoordinates> sample = Arrays.asList(start, end);
                TimeStampedFieldAngularCoordinatesHermiteInterpolator<S> interpolator = new TimeStampedFieldAngularCoordinatesHermiteInterpolator<S>(sample.size(), Switch.this.transitionFilter);
                TimeStampedFieldAngularCoordinates interpolated = interpolator.interpolate(date, sample);
                return new FieldAttitude(frame, interpolated);
            }
        }
    }
}

