/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.AngularCoordinates;
import org.orekit.utils.FieldAngularCoordinates;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;

public interface AttitudeProviderModifier
extends AttitudeProvider {
    public AttitudeProvider getUnderlyingAttitudeProvider();

    public static AttitudeProviderModifier getFrozenAttitudeProvider(final AttitudeProvider attitudeProvider) {
        return new AttitudeProviderModifier(){

            @Override
            public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
                Rotation rotation = attitudeProvider.getAttitudeRotation(pvProv, date, frame);
                AngularCoordinates angularCoordinates = new AngularCoordinates(rotation, Vector3D.ZERO);
                return new Attitude(date, frame, angularCoordinates);
            }

            @Override
            public <T extends CalculusFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
                FieldRotation<T> rotation = attitudeProvider.getAttitudeRotation(pvProv, date, frame);
                FieldAngularCoordinates<T> angularCoordinates = new FieldAngularCoordinates<T>(rotation, FieldVector3D.getZero(date.getField()));
                return new FieldAttitude<T>(date, frame, angularCoordinates);
            }

            @Override
            public AttitudeProvider getUnderlyingAttitudeProvider() {
                return attitudeProvider;
            }
        };
    }
}

