/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.orekit.attitudes.Attitude;
import org.orekit.frames.Frame;
import org.orekit.time.AbstractTimeInterpolator;
import org.orekit.time.TimeInterpolator;
import org.orekit.utils.TimeStampedAngularCoordinates;

public class AttitudeInterpolator
extends AbstractTimeInterpolator<Attitude> {
    private final Frame referenceFrame;
    private final TimeInterpolator<TimeStampedAngularCoordinates> interpolator;

    public AttitudeInterpolator(Frame referenceFrame, TimeInterpolator<TimeStampedAngularCoordinates> interpolator) {
        super(interpolator.getNbInterpolationPoints(), interpolator.getExtrapolationThreshold());
        this.referenceFrame = referenceFrame;
        this.interpolator = interpolator;
    }

    public Frame getReferenceFrame() {
        return this.referenceFrame;
    }

    public TimeInterpolator<TimeStampedAngularCoordinates> getAngularInterpolator() {
        return this.interpolator;
    }

    @Override
    protected Attitude interpolate(AbstractTimeInterpolator.InterpolationData interpolationData) {
        Stream sample = interpolationData.getNeighborList().stream();
        Stream<Attitude> consistentSample = sample.map(attitude -> attitude.withReferenceFrame(this.referenceFrame));
        List angularSample = consistentSample.map(Attitude::getOrientation).collect(Collectors.toList());
        TimeStampedAngularCoordinates interpolated = this.interpolator.interpolate(interpolationData.getInterpolationDate(), angularSample);
        return new Attitude(this.referenceFrame, interpolated);
    }
}

