/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import java.util.HashMap;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative2;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2Field;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.attitudes.TargetProvider;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.AngularCoordinates;
import org.orekit.utils.ExtendedPositionProvider;
import org.orekit.utils.FieldAngularCoordinates;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class AlignedAndConstrained
implements AttitudeProvider {
    private final FieldVector3D<UnivariateDerivative2> primarySat;
    private final TargetProvider primaryTarget;
    private final FieldVector3D<UnivariateDerivative2> secondarySat;
    private final TargetProvider secondaryTarget;
    private final ExtendedPositionProvider sun;
    private final OneAxisEllipsoid earth;
    private final transient Map<Field<? extends CalculusFieldElement<?>>, Cache<? extends CalculusFieldElement<?>>> cachedSatelliteVectors;

    public AlignedAndConstrained(Vector3D primarySat, TargetProvider primaryTarget, Vector3D secondarySat, TargetProvider secondaryTarget, ExtendedPositionProvider sun, OneAxisEllipsoid earth) {
        this.primarySat = new FieldVector3D((Field)UnivariateDerivative2Field.getInstance(), primarySat);
        this.primaryTarget = primaryTarget;
        this.secondarySat = new FieldVector3D((Field)UnivariateDerivative2Field.getInstance(), secondarySat);
        this.secondaryTarget = secondaryTarget;
        this.sun = sun;
        this.earth = earth;
        this.cachedSatelliteVectors = new HashMap();
    }

    @Override
    public Rotation getAttitudeRotation(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        TimeStampedPVCoordinates satPV = pvProv.getPVCoordinates(date, frame);
        Vector3D primaryDirection = this.primaryTarget.getTargetDirection(this.sun, this.earth, satPV, frame);
        Vector3D secondaryDirection = this.secondaryTarget.getTargetDirection(this.sun, this.earth, satPV, frame);
        return new Rotation(primaryDirection, secondaryDirection, this.primarySat.toVector3D(), this.secondarySat.toVector3D());
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        TimeStampedPVCoordinates satPV = pvProv.getPVCoordinates(date, frame);
        FieldVector3D<UnivariateDerivative2> primaryDirection = this.primaryTarget.getDerivative2TargetDirection(this.sun, this.earth, satPV, frame);
        FieldVector3D<UnivariateDerivative2> secondaryDirection = this.secondaryTarget.getDerivative2TargetDirection(this.sun, this.earth, satPV, frame);
        FieldRotation inertToSatRotation = new FieldRotation(primaryDirection, secondaryDirection, this.primarySat, this.secondarySat);
        return new Attitude(date, frame, new AngularCoordinates(inertToSatRotation));
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldRotation<T> getAttitudeRotation(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        TimeStampedFieldPVCoordinates<T> satPV = pvProv.getPVCoordinates(date, frame);
        FieldVector3D<T> primaryDirection = this.primaryTarget.getTargetDirection(this.sun, this.earth, satPV, frame);
        FieldVector3D<T> secondaryDirection = this.secondaryTarget.getTargetDirection(this.sun, this.earth, satPV, frame);
        Field<T> field = date.getField();
        return new FieldRotation(primaryDirection, secondaryDirection, new FieldVector3D(field, this.primarySat.toVector3D()), new FieldVector3D(field, this.secondarySat.toVector3D()));
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        Cache satVectors = this.cachedSatelliteVectors.computeIfAbsent(date.getField(), f -> new Cache(date.getField(), this.primarySat, this.secondarySat));
        TimeStampedFieldPVCoordinates<T> satPV = pvProv.getPVCoordinates(date, frame);
        FieldVector3D<FieldUnivariateDerivative2<T>> primaryDirection = this.primaryTarget.getDerivative2TargetDirection(this.sun, this.earth, satPV, frame);
        FieldVector3D<FieldUnivariateDerivative2<T>> secondaryDirection = this.secondaryTarget.getDerivative2TargetDirection(this.sun, this.earth, satPV, frame);
        FieldRotation inertToSatRotation = new FieldRotation(primaryDirection, secondaryDirection, satVectors.primarySat, satVectors.secondarySat);
        return new FieldAttitude<T>(date, frame, new FieldAngularCoordinates(inertToSatRotation));
    }

    private static class Cache<T extends CalculusFieldElement<T>> {
        private final FieldVector3D<FieldUnivariateDerivative2<T>> primarySat;
        private final FieldVector3D<FieldUnivariateDerivative2<T>> secondarySat;

        Cache(Field<T> field, FieldVector3D<UnivariateDerivative2> primarySat, FieldVector3D<UnivariateDerivative2> secondarySat) {
            FieldUnivariateDerivative2 zero = new FieldUnivariateDerivative2((CalculusFieldElement)field.getZero(), (CalculusFieldElement)field.getZero(), (CalculusFieldElement)field.getZero());
            this.primarySat = new FieldVector3D((CalculusFieldElement)zero.newInstance(((UnivariateDerivative2)primarySat.getX()).getValue()), (CalculusFieldElement)zero.newInstance(((UnivariateDerivative2)primarySat.getY()).getValue()), (CalculusFieldElement)zero.newInstance(((UnivariateDerivative2)primarySat.getZ()).getValue()));
            this.secondarySat = new FieldVector3D((CalculusFieldElement)zero.newInstance(((UnivariateDerivative2)secondarySat.getX()).getValue()), (CalculusFieldElement)zero.newInstance(((UnivariateDerivative2)secondarySat.getY()).getValue()), (CalculusFieldElement)zero.newInstance(((UnivariateDerivative2)secondarySat.getZ()).getValue()));
        }
    }
}

