/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.util;

import org.hipparchus.util.MathArrays;

public class SinCos {
    private final double sin;
    private final double cos;

    SinCos(double sin, double cos) {
        this.sin = sin;
        this.cos = cos;
    }

    public double sin() {
        return this.sin;
    }

    public double cos() {
        return this.cos;
    }

    public static SinCos sum(SinCos scAlpha, SinCos scBeta) {
        return new SinCos(MathArrays.linearCombination(scAlpha.sin, scBeta.cos, scAlpha.cos, scBeta.sin), MathArrays.linearCombination(scAlpha.cos, scBeta.cos, -scAlpha.sin, scBeta.sin));
    }

    public static SinCos difference(SinCos scAlpha, SinCos scBeta) {
        return new SinCos(MathArrays.linearCombination(scAlpha.sin, scBeta.cos, -scAlpha.cos, scBeta.sin), MathArrays.linearCombination(scAlpha.cos, scBeta.cos, scAlpha.sin, scBeta.sin));
    }
}

