/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;

public class RosenNumberPartitionIterator
implements Iterator<int[]> {
    private final int n;
    private final int k;
    private int[] a;
    private long count;

    public RosenNumberPartitionIterator(int n, int k) {
        this.n = n - 1;
        this.k = k - 1;
        if (k > n || k < 1) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, k, 1, n);
        }
        this.reset();
    }

    @Override
    public final boolean hasNext() {
        return this.count > 0L;
    }

    @Override
    public final int[] next() {
        int i;
        if (this.count == 0L) {
            throw new NoSuchElementException();
        }
        if (this.a == null) {
            this.a = new int[this.k];
            for (i = 0; i < this.k; ++i) {
                this.a[i] = i;
            }
        } else {
            i = this.k - 1;
            while (this.a[i] == this.n - this.k + i) {
                --i;
            }
            int n = i;
            int n2 = this.a[n] + 1;
            this.a[n] = n2;
            int t = n2 - i++;
            int j = i;
            while (j < this.k) {
                this.a[j] = t + j++;
            }
        }
        --this.count;
        int kPlus1 = this.k + 1;
        int[] temp = new int[kPlus1];
        for (int i2 = 0; i2 < kPlus1; ++i2) {
            temp[i2] = i2 == 0 ? this.a[i2] + 1 : (i2 == this.k ? this.n - this.a[i2 - 1] : this.a[i2] - this.a[i2 - 1]);
        }
        return temp;
    }

    public void reset() {
        this.count = 1L;
        for (int i = 0; i < this.k; ++i) {
            this.count = this.count * (long)(this.n - i) / (long)(i + 1);
        }
        this.a = null;
    }
}

