/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class PermutationsIterator<T>
implements Iterator<List<T>> {
    private final List<T> permuted;
    private final int[] value;
    private final int[] direction;
    private boolean exhausted;

    PermutationsIterator(List<T> list) {
        this.permuted = new ArrayList<T>(list);
        this.value = new int[list.size()];
        this.direction = new int[list.size()];
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = i;
            this.direction[i] = i == 0 ? 0 : -1;
        }
        this.exhausted = false;
    }

    @Override
    public boolean hasNext() {
        return !this.exhausted;
    }

    @Override
    public List<T> next() {
        if (this.exhausted) {
            throw new NoSuchElementException();
        }
        ArrayList<T> current = new ArrayList<T>(this.permuted);
        int selectedIndex = -1;
        int selectedValue = -1;
        int selectedDirection = -1;
        for (int i = 0; i < this.value.length; ++i) {
            if (this.direction[i] == 0 || this.value[i] <= selectedValue) continue;
            selectedIndex = i;
            selectedValue = this.value[i];
            selectedDirection = this.direction[i];
        }
        if (selectedIndex < 0) {
            this.exhausted = true;
        } else {
            int i;
            int selectedPeer = selectedIndex + selectedDirection;
            T tmp = this.permuted.get(selectedIndex);
            this.permuted.set(selectedIndex, this.permuted.get(selectedPeer));
            this.permuted.set(selectedPeer, tmp);
            this.value[selectedIndex] = this.value[selectedPeer];
            this.value[selectedPeer] = selectedValue;
            this.direction[selectedIndex] = this.direction[selectedPeer];
            this.direction[selectedPeer] = selectedPeer == 0 || selectedPeer == this.permuted.size() - 1 || this.value[selectedPeer + selectedDirection] > selectedValue ? 0 : selectedDirection;
            for (i = 0; i < selectedIndex; ++i) {
                if (this.value[i] <= selectedValue) continue;
                this.direction[i] = 1;
            }
            for (i = selectedIndex + 1; i < this.value.length; ++i) {
                if (this.value[i] <= selectedValue) continue;
                this.direction[i] = -1;
            }
        }
        return current;
    }
}

