/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.util;

import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.hipparchus.util.FastMath;

class PartitionsIterator<T>
implements Iterator<List<T>[]> {
    private final List<T> list;
    private final int n;
    private final int[] partIndex;
    private final int[] backTrack;
    private int r;
    private int j;
    private final Queue<List<T>[]> pending;
    private boolean exhausted;

    PartitionsIterator(List<T> list) {
        this.list = list;
        this.n = list.size();
        this.partIndex = new int[list.size()];
        this.backTrack = new int[list.size() - 1];
        this.r = 0;
        this.j = 0;
        this.pending = new ArrayDeque<List<T>[]>(this.n);
        this.generate();
    }

    private void generate() {
        while (this.r < this.n - 2) {
            this.partIndex[++this.r] = 0;
            this.backTrack[++this.j] = this.r;
        }
        for (int i = 0; i < this.n - this.j; ++i) {
            int k;
            this.partIndex[this.n - 1] = i;
            int max = 0;
            for (int index : this.partIndex) {
                max = FastMath.max(max, index);
            }
            List[] partition = (List[])Array.newInstance(List.class, max + 1);
            for (k = 0; k < partition.length; ++k) {
                partition[k] = new ArrayList(this.n);
            }
            for (k = 0; k < this.partIndex.length; ++k) {
                partition[this.partIndex[k]].add(this.list.get(k));
            }
            this.pending.add(partition);
        }
        int n = this.r = this.backTrack[this.j];
        this.partIndex[n] = this.partIndex[n] + 1;
        if (this.partIndex[this.r] > this.r - this.j) {
            --this.j;
        }
        this.exhausted = this.r == 0;
    }

    @Override
    public boolean hasNext() {
        return !this.exhausted || !this.pending.isEmpty();
    }

    @Override
    public List<T>[] next() {
        if (this.pending.isEmpty()) {
            if (this.exhausted) {
                throw new NoSuchElementException();
            }
            this.generate();
        }
        return this.pending.remove();
    }
}

