/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.AbstractOpenIntHashMap;

public class OpenIntToFieldHashMap<T extends FieldElement<T>>
extends AbstractOpenIntHashMap
implements Serializable {
    private static final long serialVersionUID = 20240326L;
    private final Field<T> field;
    private T[] values;
    private final T missingEntries;

    public OpenIntToFieldHashMap(Field<T> field) {
        this(field, 16, field.getZero());
    }

    public OpenIntToFieldHashMap(Field<T> field, T missingEntries) {
        this(field, 16, missingEntries);
    }

    public OpenIntToFieldHashMap(Field<T> field, int expectedSize) {
        this(field, expectedSize, field.getZero());
    }

    public OpenIntToFieldHashMap(Field<T> field, int expectedSize, T missingEntries) {
        super(expectedSize);
        this.field = field;
        this.values = this.buildArray(this.getCapacity());
        this.missingEntries = missingEntries;
    }

    public OpenIntToFieldHashMap(OpenIntToFieldHashMap<T> source) {
        super(source);
        this.field = source.field;
        this.values = this.buildArray(this.getCapacity());
        System.arraycopy(source.values, 0, this.values, 0, this.getCapacity());
        this.missingEntries = source.missingEntries;
    }

    public T get(int key) {
        int index = this.locate(key);
        return index < 0 ? this.missingEntries : this.values[index];
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenIntToFieldHashMap that = (OpenIntToFieldHashMap)o;
        return this.equalKeys(that) && this.equalStates(that) && this.field.equals(that.field) && Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        return this.keysStatesHashCode() + 67 * this.field.hashCode() + Arrays.hashCode(this.values);
    }

    public T remove(int key) {
        int index = this.locate(key);
        if (index < 0) {
            return this.missingEntries;
        }
        T previous = this.values[index];
        this.doRemove(index);
        this.values[index] = this.missingEntries;
        return previous;
    }

    public T put(int key, T value) {
        AbstractOpenIntHashMap.InsertionHolder ih = this.put(key);
        T previous = ih.isExisting() ? this.values[ih.getIndex()] : this.missingEntries;
        this.values[ih.getIndex()] = value;
        return previous;
    }

    @Override
    protected int growTable(int oldIndex) {
        FieldElement[] newValues = this.buildArray(2 * this.values.length);
        int newIndex = this.doGrowTable(oldIndex, (src, dest) -> {
            newValues[dest] = this.values[src];
        });
        this.values = newValues;
        return newIndex;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.resetCount();
    }

    private T[] buildArray(int length) {
        return (FieldElement[])Array.newInstance(this.field.getRuntimeClass(), length);
    }

    public class Iterator
    extends AbstractOpenIntHashMap.BaseIterator {
        public T value() throws ConcurrentModificationException, NoSuchElementException {
            return OpenIntToFieldHashMap.this.values[this.getCurrent()];
        }
    }
}

