/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.util;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.util.Precision;

public abstract class FieldContinuedFraction {
    private static final double DEFAULT_EPSILON = 1.0E-8;

    protected FieldContinuedFraction() {
    }

    public abstract <T extends CalculusFieldElement<T>> T getA(int var1, T var2);

    public abstract <T extends CalculusFieldElement<T>> T getB(int var1, T var2);

    public <T extends CalculusFieldElement<T>> T evaluate(T x) throws MathIllegalStateException {
        return this.evaluate(x, 1.0E-8, Integer.MAX_VALUE);
    }

    public <T extends CalculusFieldElement<T>> T evaluate(T x, double epsilon) throws MathIllegalStateException {
        return this.evaluate(x, epsilon, Integer.MAX_VALUE);
    }

    public <T extends CalculusFieldElement<T>> T evaluate(T x, int maxIterations) throws MathIllegalStateException {
        return this.evaluate(x, 1.0E-8, maxIterations);
    }

    public <T extends CalculusFieldElement<T>> T evaluate(T x, double epsilon, int maxIterations) throws MathIllegalStateException {
        int n;
        CalculusFieldElement zero = (CalculusFieldElement)x.getField().getZero();
        CalculusFieldElement one = (CalculusFieldElement)x.getField().getOne();
        double small = 1.0E-50;
        CalculusFieldElement smallField = (CalculusFieldElement)one.multiply(1.0E-50);
        Object hPrev = this.getA(0, x);
        if (Precision.equals(hPrev.getReal(), 0.0, 1.0E-50)) {
            hPrev = (CalculusFieldElement)one.multiply(1.0E-50);
        }
        CalculusFieldElement dPrev = zero;
        Object cPrev = hPrev;
        Object hN = hPrev;
        for (n = 1; n < maxIterations; ++n) {
            CalculusFieldElement deltaN;
            CalculusFieldElement cN;
            Object b;
            CalculusFieldElement a = this.getA(n, x);
            CalculusFieldElement dN = a.add((CalculusFieldElement)(b = this.getB(n, x)).multiply((CalculusFieldElement)dPrev));
            if (Precision.equals(dN.getReal(), 0.0, 1.0E-50)) {
                dN = smallField;
            }
            if (Precision.equals((cN = a.add((CalculusFieldElement)((CalculusFieldElement)b.divide(cPrev)))).getReal(), 0.0, 1.0E-50)) {
                cN = smallField;
            }
            if ((hN = hPrev.multiply((CalculusFieldElement)(deltaN = cN.multiply(dN = (CalculusFieldElement)dN.reciprocal())))).isInfinite()) {
                throw new MathIllegalStateException(LocalizedCoreFormats.CONTINUED_FRACTION_INFINITY_DIVERGENCE, x);
            }
            if (hN.isNaN()) {
                throw new MathIllegalStateException(LocalizedCoreFormats.CONTINUED_FRACTION_NAN_DIVERGENCE, x);
            }
            if (((CalculusFieldElement)((CalculusFieldElement)deltaN.subtract(1.0)).abs()).getReal() < epsilon) break;
            dPrev = dN;
            cPrev = cN;
            hPrev = hN;
        }
        if (n >= maxIterations) {
            throw new MathIllegalStateException(LocalizedCoreFormats.NON_CONVERGENT_CONTINUED_FRACTION, maxIterations, x);
        }
        return (T)hN;
    }
}

