/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.util;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.Binary64Field;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.FieldSinhCosh;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.SinCos;
import org.hipparchus.util.SinhCosh;

public class Binary64
extends Number
implements CalculusFieldElement<Binary64>,
Comparable<Binary64> {
    public static final Binary64 ZERO = new Binary64(0.0);
    public static final Binary64 ONE = new Binary64(1.0);
    public static final Binary64 PI = new Binary64(Math.PI);
    public static final Binary64 NEGATIVE_INFINITY = new Binary64(Double.NEGATIVE_INFINITY);
    public static final Binary64 POSITIVE_INFINITY = new Binary64(Double.POSITIVE_INFINITY);
    public static final Binary64 NAN = new Binary64(Double.NaN);
    private static final long serialVersionUID = 20120227L;
    private final double value;

    public Binary64(double x) {
        this.value = x;
    }

    @Override
    public Binary64 newInstance(double v) {
        return new Binary64(v);
    }

    @Override
    public Field<Binary64> getField() {
        return Binary64Field.getInstance();
    }

    @Override
    public Binary64 add(Binary64 a) {
        return new Binary64(this.value + a.value);
    }

    @Override
    public Binary64 subtract(Binary64 a) {
        return new Binary64(this.value - a.value);
    }

    @Override
    public Binary64 negate() {
        return new Binary64(-this.value);
    }

    @Override
    public Binary64 square() {
        return this.multiply(this);
    }

    @Override
    public Binary64 multiply(Binary64 a) {
        return new Binary64(this.value * a.value);
    }

    @Override
    public Binary64 multiply(int n) {
        return new Binary64((double)n * this.value);
    }

    @Override
    public Binary64 divide(Binary64 a) {
        return new Binary64(this.value / a.value);
    }

    @Override
    public Binary64 reciprocal() {
        return new Binary64(1.0 / this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public int compareTo(Binary64 o) {
        return Double.compare(this.value, o.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Binary64) {
            Binary64 that = (Binary64)obj;
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(that.value);
        }
        return false;
    }

    @Override
    public boolean isZero() {
        return this.value == 0.0;
    }

    public int hashCode() {
        long v = Double.doubleToLongBits(this.value);
        return (int)(v ^ v >>> 32);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    @Override
    public double getReal() {
        return this.value;
    }

    @Override
    public Binary64 add(double a) {
        return new Binary64(this.value + a);
    }

    @Override
    public Binary64 subtract(double a) {
        return new Binary64(this.value - a);
    }

    @Override
    public Binary64 multiply(double a) {
        return new Binary64(this.value * a);
    }

    @Override
    public Binary64 divide(double a) {
        return new Binary64(this.value / a);
    }

    @Override
    public Binary64 remainder(double a) {
        return new Binary64(FastMath.IEEEremainder(this.value, a));
    }

    @Override
    public Binary64 remainder(Binary64 a) {
        return new Binary64(FastMath.IEEEremainder(this.value, a.value));
    }

    @Override
    public Binary64 abs() {
        return new Binary64(FastMath.abs(this.value));
    }

    @Override
    public Binary64 ceil() {
        return new Binary64(FastMath.ceil(this.value));
    }

    @Override
    public Binary64 floor() {
        return new Binary64(FastMath.floor(this.value));
    }

    @Override
    public Binary64 rint() {
        return new Binary64(FastMath.rint(this.value));
    }

    @Override
    public Binary64 sign() {
        return new Binary64(FastMath.signum(this.value));
    }

    @Override
    public Binary64 copySign(Binary64 sign) {
        return new Binary64(FastMath.copySign(this.value, sign.value));
    }

    @Override
    public Binary64 copySign(double sign) {
        return new Binary64(FastMath.copySign(this.value, sign));
    }

    @Override
    public Binary64 scalb(int n) {
        return new Binary64(FastMath.scalb(this.value, n));
    }

    @Override
    public Binary64 ulp() {
        return new Binary64(FastMath.ulp(this.value));
    }

    @Override
    public Binary64 hypot(Binary64 y) {
        return new Binary64(FastMath.hypot(this.value, y.value));
    }

    @Override
    public Binary64 sqrt() {
        return new Binary64(FastMath.sqrt(this.value));
    }

    @Override
    public Binary64 cbrt() {
        return new Binary64(FastMath.cbrt(this.value));
    }

    @Override
    public Binary64 rootN(int n) {
        if (this.value < 0.0) {
            return n % 2 == 0 ? NAN : new Binary64(-FastMath.pow(-this.value, 1.0 / (double)n));
        }
        return new Binary64(FastMath.pow(this.value, 1.0 / (double)n));
    }

    @Override
    public Binary64 pow(double p) {
        return new Binary64(FastMath.pow(this.value, p));
    }

    @Override
    public Binary64 pow(int n) {
        return new Binary64(FastMath.pow(this.value, n));
    }

    @Override
    public Binary64 pow(Binary64 e) {
        return new Binary64(FastMath.pow(this.value, e.value));
    }

    @Override
    public Binary64 exp() {
        return new Binary64(FastMath.exp(this.value));
    }

    @Override
    public Binary64 expm1() {
        return new Binary64(FastMath.expm1(this.value));
    }

    @Override
    public Binary64 log() {
        return new Binary64(FastMath.log(this.value));
    }

    @Override
    public Binary64 log1p() {
        return new Binary64(FastMath.log1p(this.value));
    }

    @Override
    public Binary64 log10() {
        return new Binary64(FastMath.log10(this.value));
    }

    @Override
    public Binary64 cos() {
        return new Binary64(FastMath.cos(this.value));
    }

    @Override
    public Binary64 sin() {
        return new Binary64(FastMath.sin(this.value));
    }

    @Override
    public FieldSinCos<Binary64> sinCos() {
        SinCos sc = FastMath.sinCos(this.value);
        return new FieldSinCos<Binary64>(new Binary64(sc.sin()), new Binary64(sc.cos()));
    }

    @Override
    public Binary64 tan() {
        return new Binary64(FastMath.tan(this.value));
    }

    @Override
    public Binary64 acos() {
        return new Binary64(FastMath.acos(this.value));
    }

    @Override
    public Binary64 asin() {
        return new Binary64(FastMath.asin(this.value));
    }

    @Override
    public Binary64 atan() {
        return new Binary64(FastMath.atan(this.value));
    }

    @Override
    public Binary64 atan2(Binary64 x) {
        return new Binary64(FastMath.atan2(this.value, x.value));
    }

    @Override
    public Binary64 cosh() {
        return new Binary64(FastMath.cosh(this.value));
    }

    @Override
    public Binary64 sinh() {
        return new Binary64(FastMath.sinh(this.value));
    }

    @Override
    public FieldSinhCosh<Binary64> sinhCosh() {
        SinhCosh sch = FastMath.sinhCosh(this.value);
        return new FieldSinhCosh<Binary64>(new Binary64(sch.sinh()), new Binary64(sch.cosh()));
    }

    @Override
    public Binary64 tanh() {
        return new Binary64(FastMath.tanh(this.value));
    }

    @Override
    public Binary64 acosh() {
        return new Binary64(FastMath.acosh(this.value));
    }

    @Override
    public Binary64 asinh() {
        return new Binary64(FastMath.asinh(this.value));
    }

    @Override
    public Binary64 atanh() {
        return new Binary64(FastMath.atanh(this.value));
    }

    @Override
    public Binary64 toDegrees() {
        return new Binary64(FastMath.toDegrees(this.value));
    }

    @Override
    public Binary64 toRadians() {
        return new Binary64(FastMath.toRadians(this.value));
    }

    public Binary64 linearCombination(Binary64[] a, Binary64[] b) throws MathIllegalArgumentException {
        MathUtils.checkDimension(a.length, b.length);
        double[] aDouble = new double[a.length];
        double[] bDouble = new double[b.length];
        for (int i = 0; i < a.length; ++i) {
            aDouble[i] = a[i].value;
            bDouble[i] = b[i].value;
        }
        return new Binary64(MathArrays.linearCombination(aDouble, bDouble));
    }

    public Binary64 linearCombination(double[] a, Binary64[] b) throws MathIllegalArgumentException {
        MathUtils.checkDimension(a.length, b.length);
        double[] bDouble = new double[b.length];
        for (int i = 0; i < a.length; ++i) {
            bDouble[i] = b[i].value;
        }
        return new Binary64(MathArrays.linearCombination(a, bDouble));
    }

    @Override
    public Binary64 linearCombination(Binary64 a1, Binary64 b1, Binary64 a2, Binary64 b2) {
        return new Binary64(MathArrays.linearCombination(a1.value, b1.value, a2.value, b2.value));
    }

    @Override
    public Binary64 linearCombination(double a1, Binary64 b1, double a2, Binary64 b2) {
        return new Binary64(MathArrays.linearCombination(a1, b1.value, a2, b2.value));
    }

    @Override
    public Binary64 linearCombination(Binary64 a1, Binary64 b1, Binary64 a2, Binary64 b2, Binary64 a3, Binary64 b3) {
        return new Binary64(MathArrays.linearCombination(a1.value, b1.value, a2.value, b2.value, a3.value, b3.value));
    }

    @Override
    public Binary64 linearCombination(double a1, Binary64 b1, double a2, Binary64 b2, double a3, Binary64 b3) {
        return new Binary64(MathArrays.linearCombination(a1, b1.value, a2, b2.value, a3, b3.value));
    }

    @Override
    public Binary64 linearCombination(Binary64 a1, Binary64 b1, Binary64 a2, Binary64 b2, Binary64 a3, Binary64 b3, Binary64 a4, Binary64 b4) {
        return new Binary64(MathArrays.linearCombination(a1.value, b1.value, a2.value, b2.value, a3.value, b3.value, a4.value, b4.value));
    }

    @Override
    public Binary64 linearCombination(double a1, Binary64 b1, double a2, Binary64 b2, double a3, Binary64 b3, double a4, Binary64 b4) {
        return new Binary64(MathArrays.linearCombination(a1, b1.value, a2, b2.value, a3, b3.value, a4, b4.value));
    }

    @Override
    public Binary64 getPi() {
        return PI;
    }
}

