/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.jacobi;

import org.hipparchus.special.elliptic.carlson.CarlsonEllipticIntegral;
import org.hipparchus.special.elliptic.jacobi.CopolarC;
import org.hipparchus.special.elliptic.jacobi.CopolarD;
import org.hipparchus.special.elliptic.jacobi.CopolarN;
import org.hipparchus.special.elliptic.jacobi.CopolarS;
import org.hipparchus.special.elliptic.legendre.LegendreEllipticIntegral;
import org.hipparchus.util.FastMath;

public abstract class JacobiElliptic {
    private final double m;

    protected JacobiElliptic(double m) {
        this.m = m;
    }

    public double getM() {
        return this.m;
    }

    public abstract CopolarN valuesN(double var1);

    public CopolarS valuesS(double u) {
        return new CopolarS(this.valuesN(u));
    }

    public CopolarC valuesC(double u) {
        return new CopolarC(this.valuesN(u));
    }

    public CopolarD valuesD(double u) {
        return new CopolarD(this.valuesN(u));
    }

    public double arcsn(double x) {
        return this.arcsp(x, -1.0, -this.getM());
    }

    public double arccn(double x) {
        return this.arcpq(x, 1.0, -this.getM());
    }

    public double arcdn(double x) {
        return this.arcpq(x, this.getM(), -1.0);
    }

    public double arccs(double x) {
        return this.arcps(x, 1.0, 1.0 - this.getM());
    }

    public double arcds(double x) {
        return this.arcps(x, this.getM() - 1.0, this.getM());
    }

    public double arcns(double x) {
        return this.arcps(x, -1.0, -this.getM());
    }

    public double arcdc(double x) {
        return this.arcpq(x, this.getM() - 1.0, 1.0);
    }

    public double arcnc(double x) {
        return this.arcpq(x, -1.0, 1.0 - this.getM());
    }

    public double arcsc(double x) {
        return this.arcsp(x, 1.0, 1.0 - this.getM());
    }

    public double arcnd(double x) {
        return this.arcpq(x, -this.getM(), this.getM() - 1.0);
    }

    public double arcsd(double x) {
        return this.arcsp(x, this.getM(), this.getM() - 1.0);
    }

    public double arccd(double x) {
        return this.arcpq(x, 1.0 - this.getM(), this.getM());
    }

    private double arcps(double x, double deltaQP, double deltaRP) {
        double x2 = x * x;
        return FastMath.copySign(CarlsonEllipticIntegral.rF(x2, x2 + deltaQP, x2 + deltaRP), x);
    }

    private double arcsp(double x, double deltaQP, double deltaRP) {
        double x2 = x * x;
        return x * CarlsonEllipticIntegral.rF(1.0, 1.0 + deltaQP * x2, 1.0 + deltaRP * x2);
    }

    private double arcpq(double x, double deltaQP, double deltaRQ) {
        double x2 = x * x;
        double w = (1.0 - x2) / deltaQP;
        double positive = FastMath.sqrt(w) * CarlsonEllipticIntegral.rF(x2, 1.0, 1.0 + deltaRQ * w);
        return x < 0.0 ? 2.0 * LegendreEllipticIntegral.bigK(this.getM()) - positive : positive;
    }
}

