/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.jacobi;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.special.elliptic.carlson.CarlsonEllipticIntegral;
import org.hipparchus.special.elliptic.jacobi.FieldCopolarC;
import org.hipparchus.special.elliptic.jacobi.FieldCopolarD;
import org.hipparchus.special.elliptic.jacobi.FieldCopolarN;
import org.hipparchus.special.elliptic.jacobi.FieldCopolarS;
import org.hipparchus.special.elliptic.legendre.LegendreEllipticIntegral;
import org.hipparchus.util.FastMath;

public abstract class FieldJacobiElliptic<T extends CalculusFieldElement<T>> {
    private final T m;

    protected FieldJacobiElliptic(T m) {
        this.m = m;
    }

    public T getM() {
        return this.m;
    }

    public abstract FieldCopolarN<T> valuesN(T var1);

    public FieldCopolarN<T> valuesN(double u) {
        return this.valuesN((CalculusFieldElement)this.m.newInstance(u));
    }

    public FieldCopolarS<T> valuesS(T u) {
        return new FieldCopolarS<T>(this.valuesN(u));
    }

    public FieldCopolarS<T> valuesS(double u) {
        return new FieldCopolarS<T>(this.valuesN(u));
    }

    public FieldCopolarC<T> valuesC(T u) {
        return new FieldCopolarC<T>(this.valuesN(u));
    }

    public FieldCopolarC<T> valuesC(double u) {
        return new FieldCopolarC<T>(this.valuesN(u));
    }

    public FieldCopolarD<T> valuesD(T u) {
        return new FieldCopolarD<T>(this.valuesN(u));
    }

    public FieldCopolarD<T> valuesD(double u) {
        return new FieldCopolarD<T>(this.valuesN(u));
    }

    public T arcsn(T x) {
        return (T)this.arcsp(x, (CalculusFieldElement)((CalculusFieldElement)x.getField().getOne()).negate(), (CalculusFieldElement)this.getM().negate());
    }

    public T arcsn(double x) {
        return (T)this.arcsn((CalculusFieldElement)((CalculusFieldElement)this.getM().getField().getZero()).newInstance(x));
    }

    public T arccn(T x) {
        return (T)this.arcpqNoDivision(x, (CalculusFieldElement)x.getField().getOne(), (CalculusFieldElement)this.getM().negate());
    }

    public T arccn(double x) {
        return (T)this.arccn((CalculusFieldElement)((CalculusFieldElement)this.getM().getField().getZero()).newInstance(x));
    }

    public T arcdn(T x) {
        return (T)this.arcpqNoDivision(x, this.getM(), (CalculusFieldElement)((CalculusFieldElement)x.getField().getOne()).negate());
    }

    public T arcdn(double x) {
        return (T)this.arcdn((CalculusFieldElement)((CalculusFieldElement)this.getM().getField().getZero()).newInstance(x));
    }

    public T arccs(T x) {
        return (T)this.arcps(x, (CalculusFieldElement)x.getField().getOne(), (CalculusFieldElement)((CalculusFieldElement)this.getM().subtract((double)1.0)).negate());
    }

    public T arccs(double x) {
        return (T)this.arccs((CalculusFieldElement)((CalculusFieldElement)this.getM().getField().getZero()).newInstance(x));
    }

    public T arcds(T x) {
        return (T)this.arcps(x, (CalculusFieldElement)this.getM().subtract((double)1.0), this.getM());
    }

    public T arcds(double x) {
        return (T)this.arcds((CalculusFieldElement)((CalculusFieldElement)this.getM().getField().getZero()).newInstance(x));
    }

    public T arcns(T x) {
        return (T)this.arcps(x, (CalculusFieldElement)((CalculusFieldElement)x.getField().getOne()).negate(), (CalculusFieldElement)this.getM().negate());
    }

    public T arcns(double x) {
        return (T)this.arcns((CalculusFieldElement)((CalculusFieldElement)this.getM().getField().getZero()).newInstance(x));
    }

    public T arcdc(T x) {
        return (T)this.arcpq(x, (CalculusFieldElement)this.getM().subtract((double)1.0), (CalculusFieldElement)x.getField().getOne());
    }

    public T arcdc(double x) {
        return (T)this.arcdc((CalculusFieldElement)((CalculusFieldElement)this.getM().getField().getZero()).newInstance(x));
    }

    public T arcnc(T x) {
        return (T)this.arcpq(x, (CalculusFieldElement)((CalculusFieldElement)x.getField().getOne()).negate(), (CalculusFieldElement)((CalculusFieldElement)this.getM().subtract((double)1.0)).negate());
    }

    public T arcnc(double x) {
        return (T)this.arcnc((CalculusFieldElement)((CalculusFieldElement)this.getM().getField().getZero()).newInstance(x));
    }

    public T arcsc(T x) {
        return (T)this.arcsp(x, (CalculusFieldElement)x.getField().getOne(), (CalculusFieldElement)((CalculusFieldElement)this.getM().subtract((double)1.0)).negate());
    }

    public T arcsc(double x) {
        return (T)this.arcsc((CalculusFieldElement)((CalculusFieldElement)this.getM().getField().getZero()).newInstance(x));
    }

    public T arcnd(T x) {
        return (T)this.arcpq(x, (CalculusFieldElement)this.getM().negate(), (CalculusFieldElement)this.getM().subtract((double)1.0));
    }

    public T arcnd(double x) {
        return (T)this.arcnd((CalculusFieldElement)((CalculusFieldElement)this.getM().getField().getZero()).newInstance(x));
    }

    public T arcsd(T x) {
        return (T)this.arcsp(x, this.getM(), (CalculusFieldElement)this.getM().subtract((double)1.0));
    }

    public T arcsd(double x) {
        return (T)this.arcsd((CalculusFieldElement)((CalculusFieldElement)this.getM().getField().getZero()).newInstance(x));
    }

    public T arccd(T x) {
        return (T)this.arcpq(x, (CalculusFieldElement)((CalculusFieldElement)this.getM().subtract((double)1.0)).negate(), this.getM());
    }

    public T arccd(double x) {
        return (T)this.arccd((CalculusFieldElement)((CalculusFieldElement)this.getM().getField().getZero()).newInstance(x));
    }

    private T arcps(T x, T deltaQP, T deltaRP) {
        CalculusFieldElement x2 = (CalculusFieldElement)x.square();
        CalculusFieldElement rf = CarlsonEllipticIntegral.rF(x2, (CalculusFieldElement)x2.add(deltaQP), (CalculusFieldElement)x2.add(deltaRP));
        return (T)(FastMath.copySign(1.0, rf.getReal()) * FastMath.copySign(1.0, x.getReal()) < 0.0 ? (CalculusFieldElement)rf.negate() : rf);
    }

    private T arcsp(T x, T deltaQP, T deltaRP) {
        CalculusFieldElement x2 = (CalculusFieldElement)x.square();
        return (T)x.multiply((CalculusFieldElement)CarlsonEllipticIntegral.rF((CalculusFieldElement)x.getField().getOne(), (CalculusFieldElement)deltaQP.multiply((CalculusFieldElement)x2).add(1.0), (CalculusFieldElement)deltaRP.multiply((CalculusFieldElement)x2).add(1.0)));
    }

    private T arcpq(T x, T deltaQP, T deltaRQ) {
        CalculusFieldElement x2 = (CalculusFieldElement)x.square();
        CalculusFieldElement w = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x2.subtract(1.0)).negate()).divide(deltaQP);
        CalculusFieldElement rf = CarlsonEllipticIntegral.rF(x2, (CalculusFieldElement)x.getField().getOne(), (CalculusFieldElement)deltaRQ.multiply((CalculusFieldElement)w).add(1.0));
        CalculusFieldElement positive = ((CalculusFieldElement)w.sqrt()).multiply(rf);
        return (T)(x.getReal() < 0.0 ? ((CalculusFieldElement)LegendreEllipticIntegral.bigK(this.getM()).multiply(2)).subtract(positive) : positive);
    }

    private T arcpqNoDivision(T x, T deltaQP, T deltaRQ) {
        CalculusFieldElement x2 = (CalculusFieldElement)x.square();
        CalculusFieldElement wDeltaQP = (CalculusFieldElement)((CalculusFieldElement)x2.subtract(1.0)).negate();
        CalculusFieldElement rf = CarlsonEllipticIntegral.rF((CalculusFieldElement)x2.multiply(deltaQP), deltaQP, (CalculusFieldElement)deltaRQ.multiply((CalculusFieldElement)wDeltaQP).add(deltaQP));
        CalculusFieldElement positive = ((CalculusFieldElement)wDeltaQP.sqrt()).multiply(rf);
        return (T)(FastMath.copySign(1.0, x.getReal()) < 0.0 ? ((CalculusFieldElement)LegendreEllipticIntegral.bigK(this.getM()).multiply(2)).subtract(positive) : positive);
    }
}

