/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.jacobi;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.complex.FieldComplex;
import org.hipparchus.complex.FieldComplexField;
import org.hipparchus.special.elliptic.jacobi.FieldCopolarN;
import org.hipparchus.special.elliptic.jacobi.FieldJacobiElliptic;
import org.hipparchus.special.elliptic.jacobi.FieldJacobiTheta;
import org.hipparchus.special.elliptic.jacobi.FieldTheta;
import org.hipparchus.special.elliptic.legendre.LegendreEllipticIntegral;
import org.hipparchus.util.FastMath;

class FieldComplexParameter<T extends CalculusFieldElement<T>>
extends FieldJacobiElliptic<FieldComplex<T>> {
    private final FieldJacobiTheta<FieldComplex<T>> jacobiTheta;
    private final FieldComplex<T> bigK;
    private final FieldComplex<T> iBigKPrime;
    private final T rK;
    private final T iK;
    private final T rKPrime;
    private final T iKPrime;
    private final FieldTheta<FieldComplex<T>> t0;
    private final FieldComplex<T> scaling;

    FieldComplexParameter(FieldComplex<T> m) {
        super(m);
        FieldComplex<T> q = LegendreEllipticIntegral.nome(m);
        this.bigK = LegendreEllipticIntegral.bigK(m);
        this.iBigKPrime = LegendreEllipticIntegral.bigKPrime(m).multiplyPlusI();
        CalculusFieldElement inverse = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.bigK.getRealPart().multiply(this.iBigKPrime.getImaginaryPart())).subtract((CalculusFieldElement)this.bigK.getImaginaryPart().multiply(this.iBigKPrime.getRealPart())).multiply(4)).reciprocal();
        this.rK = this.iBigKPrime.getImaginaryPart().multiply((CalculusFieldElement)inverse);
        this.iK = (CalculusFieldElement)this.iBigKPrime.getRealPart().multiply((CalculusFieldElement)inverse).negate();
        this.rKPrime = (CalculusFieldElement)this.bigK.getImaginaryPart().multiply((CalculusFieldElement)inverse).negate();
        this.iKPrime = this.bigK.getRealPart().multiply((CalculusFieldElement)inverse);
        this.jacobiTheta = new FieldJacobiTheta<FieldComplex<FieldComplex<T>>>(q);
        this.t0 = this.jacobiTheta.values((FieldComplex<FieldElement>)((FieldComplexField)m.getField()).getZero());
        this.scaling = ((FieldComplex)this.bigK.reciprocal()).multiply(((FieldComplex)m.getPi()).multiply(0.5));
    }

    @Override
    public FieldCopolarN<FieldComplex<T>> valuesN(FieldComplex<T> u) {
        CalculusFieldElement cK = ((CalculusFieldElement)this.rK.multiply(u.getRealPart())).add((CalculusFieldElement)this.iK.multiply(u.getImaginaryPart()));
        CalculusFieldElement cKPrime = ((CalculusFieldElement)this.rKPrime.multiply(u.getRealPart())).add((CalculusFieldElement)this.iKPrime.multiply(u.getImaginaryPart()));
        FieldComplex<FieldComplex<T>> reducedU = u.linearCombination(1.0, u, -4.0 * FastMath.rint(cK.getReal()), this.bigK, -4.0 * FastMath.rint(cKPrime.getReal()), this.iBigKPrime);
        FieldTheta<FieldComplex<FieldComplex<T>>> tZ = this.jacobiTheta.values(reducedU.multiply(this.scaling));
        FieldComplex<FieldComplex<FieldComplex<FieldComplex<T>>>> sn = this.t0.theta3().multiply(tZ.theta1()).divide((FieldComplex<FieldComplex<FieldComplex<FieldComplex<FieldComplex<T>>>>>)this.t0.theta2().multiply(tZ.theta4()));
        FieldComplex<FieldComplex<FieldComplex<FieldComplex<T>>>> cn = this.t0.theta4().multiply(tZ.theta2()).divide((FieldComplex<FieldComplex<FieldComplex<FieldComplex<FieldComplex<T>>>>>)this.t0.theta2().multiply(tZ.theta4()));
        FieldComplex<FieldComplex<FieldComplex<FieldComplex<T>>>> dn = this.t0.theta4().multiply(tZ.theta3()).divide((FieldComplex<FieldComplex<FieldComplex<FieldComplex<FieldComplex<T>>>>>)this.t0.theta3().multiply(tZ.theta4()));
        return new FieldCopolarN<FieldComplex<T>>(sn, cn, dn);
    }
}

