/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.carlson;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.special.elliptic.carlson.FieldDuplication;
import org.hipparchus.util.FastMath;

class RdFieldDuplication<T extends CalculusFieldElement<T>>
extends FieldDuplication<T> {
    private T sum;

    RdFieldDuplication(T x, T y, T z) {
        super(new CalculusFieldElement[]{x, y, z});
        this.sum = (CalculusFieldElement)x.getField().getZero();
    }

    @Override
    protected void initialMeanPoint(T[] va) {
        va[3] = (CalculusFieldElement)((CalculusFieldElement)va[0].add(va[1])).add((CalculusFieldElement)va[2].multiply(3)).divide(5.0);
    }

    @Override
    protected T convergenceCriterion(T r, T max) {
        return (T)max.divide((CalculusFieldElement)FastMath.sqrt(FastMath.sqrt(FastMath.sqrt((CalculusFieldElement)r.multiply(0.25)))));
    }

    @Override
    protected void update(int m, T[] vaM, T[] sqrtM, double fourM) {
        CalculusFieldElement lambdaA = (CalculusFieldElement)sqrtM[0].multiply(sqrtM[1]);
        CalculusFieldElement lambdaB = (CalculusFieldElement)sqrtM[0].multiply(sqrtM[2]);
        CalculusFieldElement lambdaC = (CalculusFieldElement)sqrtM[1].multiply(sqrtM[2]);
        CalculusFieldElement lambda = lambdaA.add(lambdaB).add(lambdaC);
        this.sum = this.sum.add((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)vaM[2].add((CalculusFieldElement)lambda).multiply(sqrtM[2])).multiply(fourM)).reciprocal()));
        vaM[0] = vaM[0].linearCombination(0.25, vaM[0], 0.25, (CalculusFieldElement)lambdaA, 0.25, (CalculusFieldElement)lambdaB, 0.25, (CalculusFieldElement)lambdaC);
        vaM[1] = vaM[1].linearCombination(0.25, vaM[1], 0.25, (CalculusFieldElement)lambdaA, 0.25, (CalculusFieldElement)lambdaB, 0.25, (CalculusFieldElement)lambdaC);
        vaM[2] = vaM[2].linearCombination(0.25, vaM[2], 0.25, (CalculusFieldElement)lambdaA, 0.25, (CalculusFieldElement)lambdaB, 0.25, (CalculusFieldElement)lambdaC);
        vaM[3] = vaM[3].linearCombination(0.25, vaM[3], 0.25, (CalculusFieldElement)lambdaA, 0.25, (CalculusFieldElement)lambdaB, 0.25, (CalculusFieldElement)lambdaC);
    }

    @Override
    protected T evaluate(T[] va0, T aM, double fourM) {
        CalculusFieldElement inv = (CalculusFieldElement)((CalculusFieldElement)aM.multiply(fourM)).reciprocal();
        CalculusFieldElement bigX = ((CalculusFieldElement)va0[3].subtract(va0[0])).multiply(inv);
        CalculusFieldElement bigY = ((CalculusFieldElement)va0[3].subtract(va0[1])).multiply(inv);
        CalculusFieldElement bigZ = (CalculusFieldElement)bigX.add(bigY).divide(-3.0);
        CalculusFieldElement bigXY = bigX.multiply(bigY);
        CalculusFieldElement bigZ2 = bigZ.multiply(bigZ);
        CalculusFieldElement e2 = bigXY.subtract((CalculusFieldElement)bigZ2.multiply(6));
        CalculusFieldElement e3 = ((CalculusFieldElement)bigXY.multiply(3)).subtract((CalculusFieldElement)bigZ2.multiply(8)).multiply(bigZ);
        CalculusFieldElement e4 = ((CalculusFieldElement)bigXY.subtract(bigZ2).multiply(3)).multiply(bigZ2);
        CalculusFieldElement e5 = bigXY.multiply(bigZ2).multiply(bigZ);
        CalculusFieldElement e2e2 = e2.multiply(e2);
        CalculusFieldElement e2e3 = e2.multiply(e3);
        CalculusFieldElement e2e4 = e2.multiply(e4);
        CalculusFieldElement e2e5 = e2.multiply(e5);
        CalculusFieldElement e3e3 = e3.multiply(e3);
        CalculusFieldElement e3e4 = e3.multiply(e4);
        CalculusFieldElement e2e2e2 = e2e2.multiply(e2);
        CalculusFieldElement e2e2e3 = e2e2.multiply(e3);
        CalculusFieldElement poly = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e3e4.add(e2e5).multiply(-540540.0)).add((CalculusFieldElement)e2e2e3.multiply(675675.0)).add((CalculusFieldElement)e2e4.multiply(612612.0)).add((CalculusFieldElement)e3e3.multiply(306306.0)).add((CalculusFieldElement)e2e2e2.multiply(-255255.0)).add((CalculusFieldElement)e5.multiply(471240.0)).add((CalculusFieldElement)e2e3.multiply(-706860.0)).add((CalculusFieldElement)e4.multiply(-556920.0)).add((CalculusFieldElement)e2e2.multiply(417690.0)).add((CalculusFieldElement)e3.multiply(680680.0)).add((CalculusFieldElement)e2.multiply(-875160.0)).add(4084080.0)).divide(4084080.0);
        CalculusFieldElement polyTerm = poly.divide((CalculusFieldElement)((CalculusFieldElement)aM.multiply(FastMath.sqrt(aM))).multiply(fourM));
        return (T)polyTerm.add((CalculusFieldElement)this.sum.multiply(3));
    }
}

