/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.carlson;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.special.elliptic.carlson.FieldDuplication;
import org.hipparchus.util.FastMath;

class RcFieldDuplication<T extends CalculusFieldElement<T>>
extends FieldDuplication<T> {
    RcFieldDuplication(T x, T y) {
        super(new CalculusFieldElement[]{x, y});
    }

    @Override
    protected void initialMeanPoint(T[] va) {
        va[2] = (CalculusFieldElement)va[0].add((CalculusFieldElement)((CalculusFieldElement)va[1].multiply(2))).divide(3.0);
    }

    @Override
    protected T convergenceCriterion(T r, T max) {
        return (T)max.divide((CalculusFieldElement)FastMath.sqrt(FastMath.sqrt(FastMath.sqrt((CalculusFieldElement)r.multiply(3.0)))));
    }

    @Override
    protected void update(int m, T[] vaM, T[] sqrtM, double fourM) {
        CalculusFieldElement lambdaA = (CalculusFieldElement)((CalculusFieldElement)sqrtM[0].multiply(sqrtM[1])).multiply(2);
        T lambdaB = vaM[1];
        vaM[0] = vaM[0].linearCombination(0.25, vaM[0], 0.25, (CalculusFieldElement)lambdaA, 0.25, lambdaB);
        vaM[1] = vaM[1].linearCombination(0.25, vaM[1], 0.25, (CalculusFieldElement)lambdaA, 0.25, lambdaB);
        vaM[2] = vaM[2].linearCombination(0.25, vaM[2], 0.25, (CalculusFieldElement)lambdaA, 0.25, lambdaB);
    }

    @Override
    protected T evaluate(T[] va0, T aM, double fourM) {
        CalculusFieldElement s = ((CalculusFieldElement)va0[1].subtract(va0[2])).divide((CalculusFieldElement)aM.multiply(fourM));
        CalculusFieldElement poly = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)s.multiply(90090.0)).add(61215.0)).multiply(s).add(32760.0)).multiply(s).add(30030.0)).multiply(s).add(11440.0)).multiply(s).add(24024.0)).multiply(s).multiply(s).add(80080.0)).divide(80080.0);
        return (T)((CalculusFieldElement)poly.divide(FastMath.sqrt(aM)));
    }
}

