/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.random;

import org.hipparchus.random.RandomGenerator;
import org.hipparchus.util.FastMath;

public class GaussMarkovGenerator {
    private final double tau;
    private final double stationarySigma;
    private final RandomGenerator generator;
    private double last;

    public GaussMarkovGenerator(double tau, double stationarySigma, RandomGenerator generator) {
        this.tau = tau;
        this.stationarySigma = stationarySigma;
        this.generator = generator;
        this.last = Double.NaN;
    }

    public double getTau() {
        return this.tau;
    }

    public double getStationarySigma() {
        return this.stationarySigma;
    }

    public double next(double deltaT) {
        if (Double.isNaN(this.last)) {
            this.last = this.stationarySigma * this.generator.nextGaussian();
        } else {
            double phi = FastMath.exp(-deltaT / this.tau);
            double sigmaE = FastMath.sqrt(1.0 - phi * phi) * this.stationarySigma;
            this.last = phi * this.last + sigmaE * this.generator.nextGaussian();
        }
        return this.last;
    }
}

