/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import java.util.Arrays;
import java.util.Comparator;
import org.hipparchus.complex.Complex;
import org.hipparchus.linear.ComplexEigenDecomposition;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.RealMatrix;

public class OrderedComplexEigenDecomposition
extends ComplexEigenDecomposition {
    public OrderedComplexEigenDecomposition(RealMatrix matrix) {
        this(matrix, 1.0E-5, 1.0E-12, 1.0E-6);
    }

    public OrderedComplexEigenDecomposition(RealMatrix matrix, double eigenVectorsEquality, double epsilon, double epsilonAVVDCheck) {
        this(matrix, eigenVectorsEquality, epsilon, epsilonAVVDCheck, (c1, c2) -> {
            int cR = Double.compare(c1.getReal(), c2.getReal());
            if (cR == 0) {
                return Double.compare(c1.getImaginary(), c2.getImaginary());
            }
            return cR;
        });
    }

    public OrderedComplexEigenDecomposition(RealMatrix matrix, double eigenVectorsEquality, double epsilon, double epsilonAVVDCheck, Comparator<Complex> eigenValuesComparator) {
        super(matrix, eigenVectorsEquality, epsilon, epsilonAVVDCheck);
        int ij;
        FieldMatrix<Complex> D = this.getD();
        FieldMatrix<Complex> V = this.getV();
        IndexedEigenvalue[] eigenValues = new IndexedEigenvalue[D.getRowDimension()];
        for (ij = 0; ij < matrix.getRowDimension(); ++ij) {
            eigenValues[ij] = new IndexedEigenvalue(ij, D.getEntry(ij, ij));
        }
        Arrays.sort(eigenValues, (v1, v2) -> eigenValuesComparator.compare(((IndexedEigenvalue)v1).eigenValue, ((IndexedEigenvalue)v2).eigenValue));
        block1: for (ij = 0; ij < matrix.getRowDimension() - 1; ++ij) {
            int k;
            IndexedEigenvalue eij = eigenValues[ij];
            if (ij == eij.index) continue;
            Complex previousValue = D.getEntry(ij, ij);
            D.setEntry(ij, ij, eij.eigenValue);
            D.setEntry(eij.index, eij.index, previousValue);
            for (k = 0; k < matrix.getRowDimension(); ++k) {
                Complex previous = V.getEntry(k, ij);
                V.setEntry(k, ij, V.getEntry(k, eij.index));
                V.setEntry(k, eij.index, previous);
            }
            for (k = ij + 1; k < matrix.getRowDimension(); ++k) {
                if (eigenValues[k].index != ij) continue;
                eigenValues[k].index = eij.index;
                continue block1;
            }
        }
        this.matricesToEigenArrays();
        this.checkDefinition(matrix);
    }

    @Override
    public FieldMatrix<Complex> getVT() {
        return this.getV().transpose();
    }

    private static class IndexedEigenvalue {
        private int index;
        private final Complex eigenValue;

        IndexedEigenvalue(int index, Complex eigenvalue) {
            this.index = index;
            this.eigenValue = eigenvalue;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof IndexedEigenvalue) {
                IndexedEigenvalue rhs = (IndexedEigenvalue)other;
                return this.eigenValue.equals(rhs.eigenValue);
            }
            return false;
        }

        public int hashCode() {
            return 4563 + this.index + this.eigenValue.hashCode();
        }
    }
}

