/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import java.util.Arrays;
import java.util.function.Predicate;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.linear.ArrayFieldVector;
import org.hipparchus.linear.BlockFieldMatrix;
import org.hipparchus.linear.FieldDecompositionSolver;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.FieldVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

public class FieldQRDecomposition<T extends CalculusFieldElement<T>> {
    private T[][] qrt;
    private T[] rDiag;
    private FieldMatrix<T> cachedQ;
    private FieldMatrix<T> cachedQT;
    private FieldMatrix<T> cachedR;
    private FieldMatrix<T> cachedH;
    private final T threshold;
    private final Predicate<T> zeroChecker;

    public FieldQRDecomposition(FieldMatrix<T> matrix) {
        this(matrix, (CalculusFieldElement)matrix.getField().getZero());
    }

    public FieldQRDecomposition(FieldMatrix<T> matrix, T threshold) {
        this((FieldMatrix<CalculusFieldElement>)matrix, (CalculusFieldElement)threshold, e -> e.isZero());
    }

    public FieldQRDecomposition(FieldMatrix<T> matrix, T threshold, Predicate<T> zeroChecker) {
        this.threshold = threshold;
        this.zeroChecker = zeroChecker;
        int m = matrix.getRowDimension();
        int n = matrix.getColumnDimension();
        this.qrt = (CalculusFieldElement[][])matrix.transpose().getData();
        this.rDiag = (CalculusFieldElement[])MathArrays.buildArray(threshold.getField(), (int)FastMath.min(m, n));
        this.cachedQ = null;
        this.cachedQT = null;
        this.cachedR = null;
        this.cachedH = null;
        this.decompose((CalculusFieldElement[][])this.qrt);
    }

    protected void decompose(T[][] matrix) {
        for (int minor = 0; minor < FastMath.min(matrix.length, matrix[0].length); ++minor) {
            this.performHouseholderReflection(minor, (CalculusFieldElement[][])matrix);
        }
    }

    protected void performHouseholderReflection(int minor, T[][] matrix) {
        CalculusFieldElement zero;
        T[] qrtMinor = matrix[minor];
        CalculusFieldElement xNormSqr = zero = (CalculusFieldElement)this.threshold.getField().getZero();
        for (int row = minor; row < qrtMinor.length; ++row) {
            T c = qrtMinor[row];
            xNormSqr = xNormSqr.add((CalculusFieldElement)c.square());
        }
        CalculusFieldElement a = qrtMinor[minor].getReal() > 0.0 ? (CalculusFieldElement)((CalculusFieldElement)xNormSqr.sqrt()).negate() : (CalculusFieldElement)xNormSqr.sqrt();
        this.rDiag[minor] = a;
        if (!this.zeroChecker.test(a)) {
            qrtMinor[minor] = qrtMinor[minor].subtract((CalculusFieldElement)a);
            for (int col = minor + 1; col < matrix.length; ++col) {
                int row;
                T[] qrtCol = matrix[col];
                CalculusFieldElement alpha = zero;
                for (row = minor; row < qrtCol.length; ++row) {
                    alpha = alpha.subtract((CalculusFieldElement)qrtCol[row].multiply(qrtMinor[row]));
                }
                alpha = alpha.divide((CalculusFieldElement)a.multiply(qrtMinor[minor]));
                for (row = minor; row < qrtCol.length; ++row) {
                    qrtCol[row] = qrtCol[row].subtract((CalculusFieldElement)((CalculusFieldElement)alpha.multiply(qrtMinor[row])));
                }
            }
        }
    }

    public FieldMatrix<T> getR() {
        if (this.cachedR == null) {
            int n = this.qrt.length;
            int m = this.qrt[0].length;
            FieldElement[][] ra = (CalculusFieldElement[][])MathArrays.buildArray(this.threshold.getField(), (int)m, (int)n);
            for (int row = FastMath.min(m, n) - 1; row >= 0; --row) {
                ra[row][row] = this.rDiag[row];
                for (int col = row + 1; col < n; ++col) {
                    ra[row][col] = this.qrt[col][row];
                }
            }
            this.cachedR = MatrixUtils.createFieldMatrix((FieldElement[][])ra);
        }
        return this.cachedR;
    }

    public FieldMatrix<T> getQ() {
        if (this.cachedQ == null) {
            this.cachedQ = this.getQT().transpose();
        }
        return this.cachedQ;
    }

    public FieldMatrix<T> getQT() {
        if (this.cachedQT == null) {
            int minor;
            int n = this.qrt.length;
            int m = this.qrt[0].length;
            FieldElement[][] qta = (CalculusFieldElement[][])MathArrays.buildArray(this.threshold.getField(), (int)m, (int)m);
            for (minor = m - 1; minor >= FastMath.min(m, n); --minor) {
                qta[minor][minor] = (CalculusFieldElement)this.threshold.getField().getOne();
            }
            for (minor = FastMath.min(m, n) - 1; minor >= 0; --minor) {
                T[] qrtMinor = this.qrt[minor];
                qta[minor][minor] = (CalculusFieldElement)this.threshold.getField().getOne();
                if (qrtMinor[minor].isZero()) continue;
                for (int col = minor; col < m; ++col) {
                    int row;
                    CalculusFieldElement alpha = (CalculusFieldElement)this.threshold.getField().getZero();
                    for (row = minor; row < m; ++row) {
                        alpha = alpha.subtract((CalculusFieldElement)qta[col][row].multiply(qrtMinor[row]));
                    }
                    alpha = alpha.divide((CalculusFieldElement)this.rDiag[minor].multiply(qrtMinor[minor]));
                    for (row = minor; row < m; ++row) {
                        qta[col][row] = qta[col][row].add((CalculusFieldElement)((CalculusFieldElement)alpha.negate()).multiply(qrtMinor[row]));
                    }
                }
            }
            this.cachedQT = MatrixUtils.createFieldMatrix((FieldElement[][])qta);
        }
        return this.cachedQT;
    }

    public FieldMatrix<T> getH() {
        if (this.cachedH == null) {
            int n = this.qrt.length;
            int m = this.qrt[0].length;
            FieldElement[][] ha = (CalculusFieldElement[][])MathArrays.buildArray(this.threshold.getField(), (int)m, (int)n);
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < FastMath.min(i + 1, n); ++j) {
                    ha[i][j] = this.qrt[j][i].divide((CalculusFieldElement)((CalculusFieldElement)this.rDiag[j].negate()));
                }
            }
            this.cachedH = MatrixUtils.createFieldMatrix((FieldElement[][])ha);
        }
        return this.cachedH;
    }

    public FieldDecompositionSolver<T> getSolver() {
        return new FieldSolver();
    }

    private class FieldSolver
    implements FieldDecompositionSolver<T> {
        private FieldSolver() {
        }

        @Override
        public boolean isNonSingular() {
            return !this.checkSingular(FieldQRDecomposition.this.rDiag, FieldQRDecomposition.this.threshold, false);
        }

        @Override
        public FieldVector<T> solve(FieldVector<T> b) {
            int n = FieldQRDecomposition.this.qrt.length;
            int m = FieldQRDecomposition.this.qrt[0].length;
            if (b.getDimension() != m) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, b.getDimension(), m);
            }
            this.checkSingular(FieldQRDecomposition.this.rDiag, FieldQRDecomposition.this.threshold, true);
            FieldElement[] x = (CalculusFieldElement[])MathArrays.buildArray(FieldQRDecomposition.this.threshold.getField(), (int)n);
            CalculusFieldElement[] y = (CalculusFieldElement[])b.toArray();
            for (int minor = 0; minor < FastMath.min(m, n); ++minor) {
                int row;
                CalculusFieldElement[] qrtMinor = FieldQRDecomposition.this.qrt[minor];
                CalculusFieldElement dotProduct = (CalculusFieldElement)FieldQRDecomposition.this.threshold.getField().getZero();
                for (row = minor; row < m; ++row) {
                    dotProduct = dotProduct.add(y[row].multiply(qrtMinor[row]));
                }
                dotProduct = dotProduct.divide(FieldQRDecomposition.this.rDiag[minor].multiply(qrtMinor[minor]));
                for (row = minor; row < m; ++row) {
                    y[row] = y[row].add(dotProduct.multiply(qrtMinor[row]));
                }
            }
            for (int row = FieldQRDecomposition.this.rDiag.length - 1; row >= 0; --row) {
                y[row] = y[row].divide(FieldQRDecomposition.this.rDiag[row]);
                CalculusFieldElement yRow = y[row];
                CalculusFieldElement[] qrtRow = FieldQRDecomposition.this.qrt[row];
                x[row] = yRow;
                for (int i = 0; i < row; ++i) {
                    y[i] = y[i].subtract(yRow.multiply(qrtRow[i]));
                }
            }
            return new ArrayFieldVector(x, false);
        }

        @Override
        public FieldMatrix<T> solve(FieldMatrix<T> b) {
            int n = FieldQRDecomposition.this.qrt.length;
            int m = FieldQRDecomposition.this.qrt[0].length;
            if (b.getRowDimension() != m) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, b.getRowDimension(), m);
            }
            this.checkSingular(FieldQRDecomposition.this.rDiag, FieldQRDecomposition.this.threshold, true);
            int columns = b.getColumnDimension();
            int blockSize = 36;
            int cBlocks = (columns + 36 - 1) / 36;
            FieldElement[][] xBlocks = (CalculusFieldElement[][])BlockFieldMatrix.createBlocksLayout(FieldQRDecomposition.this.threshold.getField(), (int)n, (int)columns);
            FieldElement[][] y = (CalculusFieldElement[][])MathArrays.buildArray(FieldQRDecomposition.this.threshold.getField(), (int)b.getRowDimension(), (int)36);
            Object[] alpha = (CalculusFieldElement[])MathArrays.buildArray(FieldQRDecomposition.this.threshold.getField(), (int)36);
            for (int kBlock = 0; kBlock < cBlocks; ++kBlock) {
                int kStart = kBlock * 36;
                int kEnd = FastMath.min(kStart + 36, columns);
                int kWidth = kEnd - kStart;
                b.copySubMatrix(0, m - 1, kStart, kEnd - 1, y);
                for (int minor = 0; minor < FastMath.min(m, n); ++minor) {
                    int k;
                    FieldElement[] yRow;
                    CalculusFieldElement d;
                    int row;
                    CalculusFieldElement[] qrtMinor = FieldQRDecomposition.this.qrt[minor];
                    CalculusFieldElement factor = (CalculusFieldElement)FieldQRDecomposition.this.rDiag[minor].multiply(qrtMinor[minor]).reciprocal();
                    Arrays.fill(alpha, 0, kWidth, FieldQRDecomposition.this.threshold.getField().getZero());
                    for (row = minor; row < m; ++row) {
                        d = qrtMinor[row];
                        yRow = y[row];
                        for (k = 0; k < kWidth; ++k) {
                            alpha[k] = alpha[k].add((CalculusFieldElement)d.multiply(yRow[k]));
                        }
                    }
                    for (int k2 = 0; k2 < kWidth; ++k2) {
                        alpha[k2] = alpha[k2].multiply(factor);
                    }
                    for (row = minor; row < m; ++row) {
                        d = qrtMinor[row];
                        yRow = y[row];
                        for (k = 0; k < kWidth; ++k) {
                            yRow[k] = yRow[k].add(alpha[k].multiply(d));
                        }
                    }
                }
                for (int j = FieldQRDecomposition.this.rDiag.length - 1; j >= 0; --j) {
                    int jBlock = j / 36;
                    int jStart = jBlock * 36;
                    CalculusFieldElement factor = (CalculusFieldElement)FieldQRDecomposition.this.rDiag[j].reciprocal();
                    FieldElement[] yJ = y[j];
                    FieldElement[] xBlock = xBlocks[jBlock * cBlocks + kBlock];
                    int index = (j - jStart) * kWidth;
                    for (int k = 0; k < kWidth; ++k) {
                        yJ[k] = yJ[k].multiply(factor);
                        xBlock[index++] = yJ[k];
                    }
                    CalculusFieldElement[] qrtJ = FieldQRDecomposition.this.qrt[j];
                    for (int i = 0; i < j; ++i) {
                        CalculusFieldElement rIJ = qrtJ[i];
                        FieldElement[] yI = y[i];
                        for (int k = 0; k < kWidth; ++k) {
                            yI[k] = yI[k].subtract(yJ[k].multiply(rIJ));
                        }
                    }
                }
            }
            return new BlockFieldMatrix(n, columns, xBlocks, false);
        }

        @Override
        public FieldMatrix<T> getInverse() {
            return this.solve(MatrixUtils.createFieldIdentityMatrix(FieldQRDecomposition.this.threshold.getField(), FieldQRDecomposition.this.qrt[0].length));
        }

        private boolean checkSingular(T[] diag, T min, boolean raise) {
            for (Object d : diag) {
                if (!(FastMath.abs(d.getReal()) <= min.getReal())) continue;
                if (raise) {
                    throw new MathIllegalArgumentException(LocalizedCoreFormats.SINGULAR_MATRIX, new Object[0]);
                }
                return true;
            }
            return false;
        }

        @Override
        public int getRowDimension() {
            return FieldQRDecomposition.this.qrt[0].length;
        }

        @Override
        public int getColumnDimension() {
            return FieldQRDecomposition.this.qrt.length;
        }
    }
}

