/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.discrete;

import org.hipparchus.distribution.discrete.AbstractIntegerDistribution;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;

public class ZipfDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 20150501L;
    private final int numberOfElements;
    private final double exponent;
    private final double nthHarmonic;
    private double numericalMean = Double.NaN;
    private boolean numericalMeanIsCalculated;
    private double numericalVariance = Double.NaN;
    private boolean numericalVarianceIsCalculated;

    public ZipfDistribution(int numberOfElements, double exponent) throws MathIllegalArgumentException {
        if (numberOfElements <= 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSION, numberOfElements);
        }
        if (exponent <= 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.EXPONENT, exponent);
        }
        this.numberOfElements = numberOfElements;
        this.exponent = exponent;
        this.nthHarmonic = this.generalizedHarmonic(numberOfElements, exponent);
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public double getExponent() {
        return this.exponent;
    }

    @Override
    public double probability(int x) {
        if (x <= 0 || x > this.numberOfElements) {
            return 0.0;
        }
        return 1.0 / FastMath.pow((double)x, this.exponent) / this.nthHarmonic;
    }

    @Override
    public double logProbability(int x) {
        if (x <= 0 || x > this.numberOfElements) {
            return Double.NEGATIVE_INFINITY;
        }
        return -FastMath.log(x) * this.exponent - FastMath.log(this.nthHarmonic);
    }

    @Override
    public double cumulativeProbability(int x) {
        if (x <= 0) {
            return 0.0;
        }
        if (x >= this.numberOfElements) {
            return 1.0;
        }
        return this.generalizedHarmonic(x, this.exponent) / this.nthHarmonic;
    }

    @Override
    public double getNumericalMean() {
        if (!this.numericalMeanIsCalculated) {
            this.numericalMean = this.calculateNumericalMean();
            this.numericalMeanIsCalculated = true;
        }
        return this.numericalMean;
    }

    protected double calculateNumericalMean() {
        int N = this.getNumberOfElements();
        double s = this.getExponent();
        double Hs1 = this.generalizedHarmonic(N, s - 1.0);
        double Hs = this.nthHarmonic;
        return Hs1 / Hs;
    }

    @Override
    public double getNumericalVariance() {
        if (!this.numericalVarianceIsCalculated) {
            this.numericalVariance = this.calculateNumericalVariance();
            this.numericalVarianceIsCalculated = true;
        }
        return this.numericalVariance;
    }

    protected double calculateNumericalVariance() {
        int N = this.getNumberOfElements();
        double s = this.getExponent();
        double Hs2 = this.generalizedHarmonic(N, s - 2.0);
        double Hs1 = this.generalizedHarmonic(N, s - 1.0);
        double Hs = this.nthHarmonic;
        return Hs2 / Hs - Hs1 * Hs1 / (Hs * Hs);
    }

    private double generalizedHarmonic(int n, double m) {
        double value = 0.0;
        for (int k = n; k > 0; --k) {
            value += 1.0 / FastMath.pow((double)k, m);
        }
        return value;
    }

    @Override
    public int getSupportLowerBound() {
        return 1;
    }

    @Override
    public int getSupportUpperBound() {
        return this.getNumberOfElements();
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

