/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.continuous;

import org.hipparchus.distribution.continuous.AbstractRealDistribution;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;

public class TriangularDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20120112L;
    private final double a;
    private final double b;
    private final double c;

    public TriangularDistribution(double a, double c, double b) throws MathIllegalArgumentException {
        if (a >= b) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, a, b, false);
        }
        if (c < a) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL, c, a, true);
        }
        if (c > b) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE, c, b, true);
        }
        this.a = a;
        this.c = c;
        this.b = b;
    }

    public double getMode() {
        return this.c;
    }

    @Override
    public double density(double x) {
        if (x < this.a) {
            return 0.0;
        }
        if (this.a <= x && x < this.c) {
            double divident = 2.0 * (x - this.a);
            double divisor = (this.b - this.a) * (this.c - this.a);
            return divident / divisor;
        }
        if (x == this.c) {
            return 2.0 / (this.b - this.a);
        }
        if (this.c < x && x <= this.b) {
            double divident = 2.0 * (this.b - x);
            double divisor = (this.b - this.a) * (this.b - this.c);
            return divident / divisor;
        }
        return 0.0;
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x < this.a) {
            return 0.0;
        }
        if (this.a <= x && x < this.c) {
            double divident = (x - this.a) * (x - this.a);
            double divisor = (this.b - this.a) * (this.c - this.a);
            return divident / divisor;
        }
        if (x == this.c) {
            return (this.c - this.a) / (this.b - this.a);
        }
        if (this.c < x && x <= this.b) {
            double divident = (this.b - x) * (this.b - x);
            double divisor = (this.b - this.a) * (this.b - this.c);
            return 1.0 - divident / divisor;
        }
        return 1.0;
    }

    @Override
    public double getNumericalMean() {
        return (this.a + this.b + this.c) / 3.0;
    }

    @Override
    public double getNumericalVariance() {
        return (this.a * this.a + this.b * this.b + this.c * this.c - this.a * this.b - this.a * this.c - this.b * this.c) / 18.0;
    }

    @Override
    public double getSupportLowerBound() {
        return this.a;
    }

    @Override
    public double getSupportUpperBound() {
        return this.b;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public double inverseCumulativeProbability(double p) throws MathIllegalArgumentException {
        MathUtils.checkRangeInclusive(p, 0.0, 1.0);
        if (p == 0.0) {
            return this.a;
        }
        if (p == 1.0) {
            return this.b;
        }
        if (p < (this.c - this.a) / (this.b - this.a)) {
            return this.a + FastMath.sqrt(p * (this.b - this.a) * (this.c - this.a));
        }
        return this.b - FastMath.sqrt((1.0 - p) * (this.b - this.a) * (this.b - this.c));
    }
}

