/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.continuous;

import org.hipparchus.distribution.continuous.AbstractRealDistribution;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;

public class ParetoDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20130424L;
    private final double scale;
    private final double shape;

    public ParetoDistribution() {
        this(1.0, 1.0);
    }

    public ParetoDistribution(double scale, double shape) throws MathIllegalArgumentException {
        this(scale, shape, 1.0E-9);
    }

    public ParetoDistribution(double scale, double shape, double inverseCumAccuracy) throws MathIllegalArgumentException {
        super(inverseCumAccuracy);
        if (scale <= 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.SCALE, scale);
        }
        if (shape <= 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.SHAPE, shape);
        }
        this.scale = scale;
        this.shape = shape;
    }

    public double getScale() {
        return this.scale;
    }

    public double getShape() {
        return this.shape;
    }

    @Override
    public double density(double x) {
        if (x < this.scale) {
            return 0.0;
        }
        return FastMath.pow(this.scale, this.shape) / FastMath.pow(x, this.shape + 1.0) * this.shape;
    }

    @Override
    public double logDensity(double x) {
        if (x < this.scale) {
            return Double.NEGATIVE_INFINITY;
        }
        return FastMath.log(this.scale) * this.shape - FastMath.log(x) * (this.shape + 1.0) + FastMath.log(this.shape);
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= this.scale) {
            return 0.0;
        }
        return 1.0 - FastMath.pow(this.scale / x, this.shape);
    }

    @Override
    public double getNumericalMean() {
        if (this.shape <= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.shape * this.scale / (this.shape - 1.0);
    }

    @Override
    public double getNumericalVariance() {
        if (this.shape <= 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        double s = this.shape - 1.0;
        return this.scale * this.scale * this.shape / (s * s) / (this.shape - 2.0);
    }

    @Override
    public double getSupportLowerBound() {
        return this.scale;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

