/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.continuous;

import org.hipparchus.distribution.continuous.AbstractRealDistribution;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.special.Beta;
import org.hipparchus.util.FastMath;

public class FDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20160320L;
    private final double numeratorDegreesOfFreedom;
    private final double denominatorDegreesOfFreedom;
    private final double numericalVariance;

    public FDistribution(double numeratorDegreesOfFreedom, double denominatorDegreesOfFreedom) throws MathIllegalArgumentException {
        this(numeratorDegreesOfFreedom, denominatorDegreesOfFreedom, 1.0E-9);
    }

    public FDistribution(double numeratorDegreesOfFreedom, double denominatorDegreesOfFreedom, double inverseCumAccuracy) throws MathIllegalArgumentException {
        super(inverseCumAccuracy);
        if (numeratorDegreesOfFreedom <= 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DEGREES_OF_FREEDOM, numeratorDegreesOfFreedom);
        }
        if (denominatorDegreesOfFreedom <= 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DEGREES_OF_FREEDOM, denominatorDegreesOfFreedom);
        }
        this.numeratorDegreesOfFreedom = numeratorDegreesOfFreedom;
        this.denominatorDegreesOfFreedom = denominatorDegreesOfFreedom;
        this.numericalVariance = this.calculateNumericalVariance();
    }

    @Override
    public double density(double x) {
        return FastMath.exp(this.logDensity(x));
    }

    @Override
    public double logDensity(double x) {
        double nhalf = this.numeratorDegreesOfFreedom / 2.0;
        double mhalf = this.denominatorDegreesOfFreedom / 2.0;
        double logx = FastMath.log(x);
        double logn = FastMath.log(this.numeratorDegreesOfFreedom);
        double logm = FastMath.log(this.denominatorDegreesOfFreedom);
        double lognxm = FastMath.log(this.numeratorDegreesOfFreedom * x + this.denominatorDegreesOfFreedom);
        return nhalf * logn + nhalf * logx - logx + mhalf * logm - nhalf * lognxm - mhalf * lognxm - Beta.logBeta(nhalf, mhalf);
    }

    @Override
    public double cumulativeProbability(double x) {
        double ret;
        if (x <= 0.0) {
            ret = 0.0;
        } else {
            double n = this.numeratorDegreesOfFreedom;
            double m = this.denominatorDegreesOfFreedom;
            ret = Beta.regularizedBeta(n * x / (m + n * x), 0.5 * n, 0.5 * m);
        }
        return ret;
    }

    public double getNumeratorDegreesOfFreedom() {
        return this.numeratorDegreesOfFreedom;
    }

    public double getDenominatorDegreesOfFreedom() {
        return this.denominatorDegreesOfFreedom;
    }

    @Override
    public double getNumericalMean() {
        double denominatorDF = this.getDenominatorDegreesOfFreedom();
        if (denominatorDF > 2.0) {
            return denominatorDF / (denominatorDF - 2.0);
        }
        return Double.NaN;
    }

    @Override
    public double getNumericalVariance() {
        return this.numericalVariance;
    }

    private double calculateNumericalVariance() {
        double denominatorDF = this.getDenominatorDegreesOfFreedom();
        if (denominatorDF > 4.0) {
            double numeratorDF = this.getNumeratorDegreesOfFreedom();
            double denomDFMinusTwo = denominatorDF - 2.0;
            return 2.0 * (denominatorDF * denominatorDF) * (numeratorDF + denominatorDF - 2.0) / (numeratorDF * (denomDFMinusTwo * denomDFMinusTwo) * (denominatorDF - 4.0));
        }
        return Double.NaN;
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

