/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.complex;

import java.util.function.Function;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.CalculusFieldUnivariateFunction;
import org.hipparchus.analysis.integration.FieldUnivariateIntegrator;
import org.hipparchus.complex.FieldComplex;

public class FieldComplexUnivariateIntegrator<T extends CalculusFieldElement<T>> {
    private FieldUnivariateIntegrator<T> integrator;

    public FieldComplexUnivariateIntegrator(FieldUnivariateIntegrator<T> integrator) {
        this.integrator = integrator;
    }

    public FieldComplex<T> integrate(int maxEval, CalculusFieldUnivariateFunction<FieldComplex<T>> f, FieldComplex<T> start, FieldComplex<T> end) {
        FieldComplex rate = end.subtract(start);
        Function<CalculusFieldElement, FieldComplex> mapped = t -> f.value(start.add((Object)rate.multiply((FieldComplex)t)));
        CalculusFieldElement zero = (CalculusFieldElement)start.getRealPart().getField().getZero();
        CalculusFieldElement one = (CalculusFieldElement)start.getRealPart().getField().getOne();
        CalculusFieldElement real = this.integrator.integrate(maxEval, (T t) -> ((FieldComplex)mapped.apply(t)).getRealPart(), zero, one);
        CalculusFieldElement imaginary = this.integrator.integrate(maxEval, (T t) -> ((FieldComplex)mapped.apply(t)).getImaginaryPart(), zero, one);
        return new FieldComplex<CalculusFieldElement>(real, imaginary).multiply(rate);
    }

    public FieldComplex<T> integrate(int maxEval, CalculusFieldUnivariateFunction<FieldComplex<T>> f, FieldComplex<T> start, FieldComplex<T> ... path) {
        FieldComplex<FieldComplex<FieldComplex<T>>> sum = start.newInstance(0.0);
        FieldComplex<T> previous = start;
        for (FieldComplex<T> current : path) {
            sum = sum.add((FieldComplex<FieldComplex<T>>)this.integrate(maxEval, f, previous, current));
            previous = current;
        }
        return sum;
    }
}

