/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.solvers;

import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.UnivariateDifferentiableFunction;
import org.hipparchus.analysis.solvers.AbstractUnivariateDifferentiableSolver;
import org.hipparchus.analysis.solvers.UnivariateSolverUtils;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.util.FastMath;

public class NewtonRaphsonSolver
extends AbstractUnivariateDifferentiableSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public NewtonRaphsonSolver() {
        this(1.0E-6);
    }

    public NewtonRaphsonSolver(double absoluteAccuracy) {
        super(absoluteAccuracy);
    }

    @Override
    public double solve(int maxEval, UnivariateDifferentiableFunction f, double min, double max) throws MathIllegalStateException {
        return super.solve(maxEval, f, UnivariateSolverUtils.midpoint(min, max));
    }

    @Override
    protected double doSolve() throws MathIllegalStateException {
        double startValue = this.getStartValue();
        double absoluteAccuracy = this.getAbsoluteAccuracy();
        double x0 = startValue;
        while (true) {
            DerivativeStructure y0 = this.computeObjectiveValueAndDerivative(x0);
            int[] nArray = new int[]{1};
            double x1 = x0 - y0.getValue() / y0.getPartialDerivative(nArray);
            if (FastMath.abs(x1 - x0) <= absoluteAccuracy) {
                return x1;
            }
            x0 = x1;
        }
    }
}

