/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration.gauss;

import java.util.Arrays;
import java.util.SortedMap;
import java.util.TreeMap;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.integration.gauss.RuleFactory;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Incrementor;
import org.hipparchus.util.Pair;

public abstract class AbstractRuleFactory
implements RuleFactory {
    private final SortedMap<Integer, Pair<double[], double[]>> pointsAndWeights = new TreeMap<Integer, Pair<double[], double[]>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<double[], double[]> getRule(int numberOfPoints) throws MathIllegalArgumentException {
        Pair<double[], double[]> rule;
        if (numberOfPoints <= 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_OF_POINTS, numberOfPoints);
        }
        if (numberOfPoints > 1000) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE, numberOfPoints, 1000);
        }
        SortedMap<Integer, Pair<double[], double[]>> sortedMap = this.pointsAndWeights;
        synchronized (sortedMap) {
            rule = (Pair<double[], double[]>)this.pointsAndWeights.get(numberOfPoints);
            if (rule == null) {
                rule = this.computeRule(numberOfPoints);
                this.pointsAndWeights.put(numberOfPoints, rule);
            }
        }
        return new Pair<double[], double[]>((double[])rule.getFirst().clone(), (double[])rule.getSecond().clone());
    }

    protected abstract Pair<double[], double[]> computeRule(int var1) throws MathIllegalArgumentException;

    protected double[] findRoots(int n, UnivariateFunction ratioEvaluator) {
        double tol;
        double maxOffset;
        double[] roots = new double[n];
        if (n == 1) {
            roots[0] = 0.0;
        } else if (n == 2) {
            roots[0] = -1.0;
            roots[1] = 1.0;
        } else {
            double[] previousPoints = this.getRule(n - 1).getFirst();
            roots[0] = previousPoints[0];
            for (int i = 1; i < n - 1; ++i) {
                roots[i] = (previousPoints[i - 1] + previousPoints[i]) * 0.5;
            }
            roots[n - 1] = previousPoints[n - 2];
        }
        double[] ratio = new double[n];
        Incrementor incrementor = new Incrementor(1000);
        do {
            int i;
            incrementor.increment();
            for (i = 0; i < n; ++i) {
                ratio[i] = ratioEvaluator.value(roots[i]);
            }
            maxOffset = 0.0;
            i = 0;
            while (i < n) {
                double sum = 0.0;
                for (int j = 0; j < n; ++j) {
                    if (j == i) continue;
                    sum += 1.0 / (roots[i] - roots[j]);
                }
                double offset = ratio[i] / (1.0 - ratio[i] * sum);
                maxOffset = FastMath.max(maxOffset, FastMath.abs(offset));
                int n2 = i++;
                roots[n2] = roots[n2] - offset;
            }
            tol = 0.0;
            for (double r : roots) {
                tol = FastMath.max(tol, FastMath.ulp(r));
            }
        } while (maxOffset > tol);
        Arrays.sort(roots);
        return roots;
    }

    protected void enforceSymmetry(double[] roots) {
        int n = roots.length;
        for (int i = 0; i < n / 2; ++i) {
            double c;
            int idx = n - i - 1;
            roots[i] = c = (roots[i] - roots[idx]) * 0.5;
            roots[idx] = -c;
        }
        if (n % 2 != 0) {
            roots[n / 2] = 0.0;
        }
    }
}

