/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration;

import org.hipparchus.analysis.integration.BaseAbstractUnivariateIntegrator;
import org.hipparchus.analysis.integration.TrapezoidIntegrator;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.util.FastMath;

public class RombergIntegrator
extends BaseAbstractUnivariateIntegrator {
    public static final int ROMBERG_MAX_ITERATIONS_COUNT = 32;

    public RombergIntegrator(double relativeAccuracy, double absoluteAccuracy, int minimalIterationCount, int maximalIterationCount) throws MathIllegalArgumentException {
        super(relativeAccuracy, absoluteAccuracy, minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 32) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE_BOUND_EXCLUDED, maximalIterationCount, 32);
        }
    }

    public RombergIntegrator(int minimalIterationCount, int maximalIterationCount) throws MathIllegalArgumentException {
        super(minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 32) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE_BOUND_EXCLUDED, maximalIterationCount, 32);
        }
    }

    public RombergIntegrator() {
        super(3, 32);
    }

    @Override
    protected double doIntegrate() throws MathIllegalStateException {
        int m = this.iterations.getMaximalCount() + 1;
        double[] previousRow = new double[m];
        double[] currentRow = new double[m];
        TrapezoidIntegrator qtrap = new TrapezoidIntegrator();
        currentRow[0] = qtrap.stage(this, 0);
        this.iterations.increment();
        double olds = currentRow[0];
        while (true) {
            double rLimit;
            double delta;
            int i = this.iterations.getCount();
            double[] tmpRow = previousRow;
            previousRow = currentRow;
            currentRow = tmpRow;
            currentRow[0] = qtrap.stage(this, i);
            this.iterations.increment();
            for (int j = 1; j <= i; ++j) {
                double r = (1L << 2 * j) - 1L;
                double tIJm1 = currentRow[j - 1];
                currentRow[j] = tIJm1 + (tIJm1 - previousRow[j - 1]) / r;
            }
            double s = currentRow[i];
            if (i >= this.getMinimalIterationCount() && ((delta = FastMath.abs(s - olds)) <= (rLimit = this.getRelativeAccuracy() * (FastMath.abs(olds) + FastMath.abs(s)) * 0.5) || delta <= this.getAbsoluteAccuracy())) {
                return s;
            }
            olds = s;
        }
    }
}

